/**
 * bpmn-deployer - Generic web application for BPMN deployment - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.ebmwebsourcing.bpmn.deployer.client.to;

import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.infrastructure.IDefinitionsBean;
import com.google.gwt.user.client.rpc.IsSerializable;

public class BPMNFile implements IsSerializable {

    private String absolutePath;
    private IDefinitionsBean bpmnDefinitions;
    
    protected BPMNFile() {}

    public BPMNFile(String absolutePath, IDefinitionsBean defs) {
        this.absolutePath = absolutePath;
        this.bpmnDefinitions = defs;
    }

    public String getAbsolutePath() {
        return absolutePath;
    }

    public IDefinitionsBean getBPMNDefinitions() {
        return bpmnDefinitions;
    }
    
}
