/**
 * bpmn-deployer - Generic web application for BPMN deployment - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.ebmwebsourcing.bpmn.deployer.client.ui;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.ebmwebsourcing.bpmn.deployer.client.service.BPMNDeploymentServiceAsync;
import com.ebmwebsourcing.bpmn.deployer.client.to.ProcessExecutorDescription;
import com.ebmwebsourcing.bpmn.deployer.client.to.RunningProcess;
import com.ebmwebsourcing.geasytools.gwtextwidgets.panel.Panel;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.gwtext.client.widgets.MessageBox;
import com.gwtext.client.widgets.form.Checkbox;
import com.gwtext.client.widgets.form.FieldSet;
import com.gwtext.client.widgets.form.FormPanel;
import com.gwtext.client.widgets.form.TextField;
import com.gwtext.client.widgets.form.event.CheckboxListenerAdapter;
import com.gwtext.client.widgets.layout.AnchorLayout;

public class ProcessExecutorPanel extends Panel {
    
    private BPMNDeploymentServiceAsync service;
    private ProcessExecutorDescription chosenDesc;
//    private RunningProcessGrid processGrid;
    private TextField urlField;

    protected ProcessExecutorPanel(Collection<? extends ProcessExecutorDescription> descs, final BPMNDeploymentServiceAsync service) {
        super();
        setHeight(BPMNDeployerPanel.HEIGHT);
        setLayout(new AnchorLayout());
        setAutoScroll(true);
        setTitle("Choose a process executor");
        this.service = service;

        final FormPanel formPanel = new FormPanel();
        formPanel.setLabelWidth(150);  
        formPanel.setBorder(false);
        formPanel.setPaddings(5);
        formPanel.setAutoScroll(true);
        
        FieldSet kindFS = new FieldSet(); 
        kindFS.setFrame(true);  
        boolean first = true;
        final Map<Checkbox,ProcessExecutorDescription> checkBoxes = new HashMap<Checkbox, ProcessExecutorDescription>();
        for(ProcessExecutorDescription desc : descs){
            Checkbox r = new Checkbox(desc.getDisplayName());
            if(first) {
              r.setLabel("Kind of process executor:");
              r.setChecked(true);
              first = false;
            }
            kindFS.add(r);
            
            checkBoxes.put(r,desc);
            
            r.addListener(new CheckboxListenerAdapter() {
                @Override
                public void onCheck(Checkbox field, boolean checked) {
                    if(checked){
                        chosenDesc = checkBoxes.get(field);
                        for(Checkbox cb : checkBoxes.keySet()){
                            if(cb.getValue() && !cb.equals(field)){
                                cb.setChecked(false);
                            }
                        }
                        
                        formPanel.doLayout();
                    }
                }
            });
        }
        formPanel.add(kindFS);
        
        FieldSet urlFS = new FieldSet(); 
        urlFS.setFrame(true);  
        
        urlField = new TextField("Host of the process executor", "url", 200);  
        urlField.setBlankText("This field is required.");
        urlField.setAllowBlank(false); 
        urlFS.add(urlField);
        formPanel.add(urlFS);
        
        this.add(formPanel);
        //this.add(formPanel,new AnchorLayoutData("100% 40%"));
        
//        Button button = new Button("Get deployed Processes for this URL", new ButtonListenerAdapter() {
//            public void onClick(Button button, EventObject e) {
//                String url = urlField.getText();
//                if(url.isEmpty()) {
//                    MessageBox.alert("Please set the host of the server you want to use.");
//                    return;
//                }
//                chosenDesc.setHost(url);
//                
//                refreshProcessGrid();
//            }
//        });
//        formPanel.addButton(button);
//        
//        processGrid = new RunningProcessGrid();
//        this.add(processGrid,new AnchorLayoutData("100% 60%"));
    }
    
    public ProcessExecutorDescription getChosenDescription() {
        chosenDesc.setHost(urlField.getText());
        return chosenDesc;
    }
    
    protected void refreshProcessGrid() {
        showWaitingBar();
        service.getDeployedProcesses(chosenDesc,  new AsyncCallback<List<RunningProcess>>() {
            @Override
            public void onSuccess(List<RunningProcess> arg0){
                removeWaitingBar();
//                processGrid.load(arg0);
//                ProcessExecutorPanel.this.doLayout();
            }
            @Override
            public void onFailure(Throwable arg0) {
                removeWaitingBar();
                MessageBox.alert("Service Error",arg0.getMessage());
            }
        });
    }
    
    private void showWaitingBar(){
        this.getEl().mask("Please wait...", true);
    }
    
    private void removeWaitingBar(){
        this.getEl().unmask();
    }
    
}
