/**
 * bpmn-deployer - Generic web application for BPMN deployment - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.bpmn.deployer.server;

import com.ebmwebsourcing.bpmn.deployer.client.exception.ProcessExecutorServiceException;

public abstract class AbstractProcessExecutorService implements ProcessExecutorService {

    private String host;

    @Override
    public void testServiceHost(String host) throws ProcessExecutorServiceException {
        doTestServiceHost(host);
        this.host = host;
    }

    public abstract void doTestServiceHost(String host) throws ProcessExecutorServiceException;

    @Override
    public String getHost() {
        return host;
    }
    
}
