/**
 * bpmn-deployer - Generic web application for BPMN deployment - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.ebmwebsourcing.bpmn.deployer.server;

import java.io.File;
import java.util.List;

import com.ebmwebsourcing.bpmn.deployer.client.exception.ProcessExecutorServiceException;
import com.ebmwebsourcing.bpmn.deployer.client.to.RunningProcess;

public interface ProcessExecutorService {

    /**
     * Test that the provided URL does describe the wanted Process Executor
     * @param host
     * @throws ProcessExecutorServiceException if the URL is not the URL of the wanted Process Executor
     */
    public void testServiceHost(String host) throws ProcessExecutorServiceException;
    
    /**
     * 
     * @return The list of processes currently running on this process executor
     * @throws ProcessExecutorServiceException 
     */
    public List<RunningProcess> getRunningProcesses() throws ProcessExecutorServiceException;
    
    /**
     * Analyze the content of the file and deploys it on the process executor
     * @param processDescriptionFile 
     * @throws ProcessExecutorServiceException
     */
    public void deployProcess(File processDescriptionFile) throws ProcessExecutorServiceException;
    
    /**
     * @return the last host that has passed the testsServiceHost method without throwing any exception
     * or null if none did
     */
    public String getHost();
    
}
