/**
 * bpmn-deployer - Generic web application for BPMN deployment - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.ebmwebsourcing.bpmn.deployer.client.ui;

import java.util.Collection;
import java.util.List;

import com.ebmwebsourcing.bpmn.deployer.client.service.BPMNDeploymentService;
import com.ebmwebsourcing.bpmn.deployer.client.service.BPMNDeploymentServiceAsync;
import com.ebmwebsourcing.bpmn.deployer.client.to.BPMNFile;
import com.ebmwebsourcing.bpmn.deployer.client.to.ProcessExecutorDescription;
import com.ebmwebsourcing.geasytools.gwtextwidgets.panel.Panel;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.gwtext.client.core.EventObject;
import com.gwtext.client.widgets.Button;
import com.gwtext.client.widgets.MessageBox;
import com.gwtext.client.widgets.event.ButtonListenerAdapter;
import com.gwtext.client.widgets.layout.ColumnLayout;
import com.gwtext.client.widgets.layout.ColumnLayoutData;

public class BPMNDeployerPanel extends Panel {

    public static final int HEIGHT = 300;  
    private BPMNDeploymentServiceAsync service = (BPMNDeploymentServiceAsync) GWT.create(BPMNDeploymentService.class);
    
    public BPMNDeployerPanel(final BPMNFile file, Collection<ProcessExecutorDescription> descs) {
        setHeight(HEIGHT);
        setWidth(680);
        setAutoScroll(true);
        setTitle("Deploy your BPMN 2.0 processes");
        setLayout(new ColumnLayout());
        
        final ProcessChoosingPanel choosingPanel = new ProcessChoosingPanel(file.getBPMNDefinitions());
        add(choosingPanel, new ColumnLayoutData(0.4));
        
        final ProcessExecutorPanel executorPanel = new ProcessExecutorPanel(descs, service);
        add(executorPanel, new ColumnLayoutData(0.6));
        
        addButton(new Button("Deploy", new ButtonListenerAdapter() {
            @Override
            public void onClick(Button button, EventObject e) {
                ProcessExecutorDescription desc = executorPanel.getChosenDescription();
                if(desc==null) {
                    MessageBox.alert("Please choose the kind of process executor to be used for deployment.");
                    return;
                }
                else if(desc.getHost()==null || desc.getHost().isEmpty()) {
                    MessageBox.alert("Please set the host of the server you want to use.");
                    return;
                }
                
                List<String> selectedIds = choosingPanel.getSelectedProcessesIds();
                if(selectedIds==null || selectedIds.isEmpty()) {
                    MessageBox.alert("Please choose one or more process for deployment.");
                    return;
                }
                
                service.deployBPMNProcesses(selectedIds, file.getAbsolutePath(), desc, new AsyncCallback<Void>() {
                    @Override
                    public void onFailure(Throwable arg0) {
                    	removeWaitingBar();
                        MessageBox.alert("Error during Deployment",arg0.getMessage());
                    }
                    @Override
                    public void onSuccess(Void arg0) {
                    	removeWaitingBar();
                    	MessageBox.alert("The process has been succesfully deployed.");
                        //executorPanel.refreshProcessGrid();
                    }
                });
                showWaitingBar();
            }
        }));
    }
    
    private void showWaitingBar(){
        this.getEl().mask("Please wait...", true);
    }
    
    private void removeWaitingBar(){
        this.getEl().unmask();
    }
    
}
