/**
 * bpmn-deployer - Generic web application for BPMN deployment - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.ebmwebsourcing.bpmn.deployer.client.ui;

import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.bpmn.deployer.client.to.RunningProcess;
import com.ebmwebsourcing.geasytools.gwtextwidgets.grid.AbstractGrid;
import com.gwtext.client.data.FieldDef;
import com.gwtext.client.data.StringFieldDef;
import com.gwtext.client.widgets.grid.BaseColumnConfig;
import com.gwtext.client.widgets.grid.ColumnConfig;

public class RunningProcessGrid extends AbstractGrid<RunningProcess> {

    private static final String NameLabel = "Name";
    private static final String AddressLabel = "Address";
    
    protected RunningProcessGrid() {
        super();
        //this.gridPanel.setAutoExpandColumn(1);
        this.gridPanel.getView().setForceFit(true);        
    }
    
    @Override
    protected Object[] convertDataToObject(RunningProcess data) {
        return new Object[] {data.getName(), data.getExposedAddress()};
    }

    @Override
    protected List<BaseColumnConfig> getColumnsConfig() {
        ArrayList<BaseColumnConfig> cc = new ArrayList<BaseColumnConfig>();
        ColumnConfig nameC = new ColumnConfig(NameLabel,NameLabel);
        ColumnConfig addressC = new ColumnConfig(AddressLabel,AddressLabel);
        cc.add(nameC);
        cc.add(addressC);
        return cc;
    }

    @Override
    protected FieldDef[] getFieldDef() {
        return new FieldDef[] { new StringFieldDef(NameLabel),new StringFieldDef(AddressLabel) };
    }

    @Override
    protected boolean isValid(RunningProcess data) {
        return data.getName()!=null && !data.getName().isEmpty()
        && data.getExposedAddress()!=null && !data.getExposedAddress().isEmpty();
    }

}
