/**
 * bpmn-di - BPMN graphical layer domain - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.business.domain.di.impl;

import com.ebmwebsourcing.geasytools.diagrameditor.domain.diagramdefinition.interchange.api.IDiagramElement;
import com.ebmwebsourcing.geasytools.diagrameditor.domain.diagramdefinition.interchange.impl.LabeledShape;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.cloneable.annotation.CloneableField;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.cloneable.annotation.CloneableFields;
import com.ebmwebsourcing.petalsbpm.business.domain.di.api.IBPMNShape;
import com.ebmwebsourcing.petalsbpm.business.domain.di.api.ParticipantBandKind;

@CloneableFields(cloneableFields = { @CloneableField(fieldClass = IDiagramElement.class, possibleImplemClasses = {
		BPMNEdge.class, BPMNShape.class, BPMNCollaborationPlane.class,
		BPMNChoreographyPlane.class }) })
public class BPMNShape extends LabeledShape implements IBPMNShape {

	private ParticipantBandKind participantBandKind;
	private boolean expanded;
	private boolean horizontal;
	private boolean markerVisible;
	private boolean messageVisible;
	private IBPMNShape choreographyActivityShape;

	public BPMNShape() {
		super();
	}

	@Override
	public ParticipantBandKind getParticipantBandKind() {
		return participantBandKind;
	}

	public void setParticipantBandKind(ParticipantBandKind participantBandKind) {
		this.participantBandKind = participantBandKind;
	}

	public void setExpanded(boolean isExpanded) {
		this.expanded = isExpanded;
	}

	@Override
	public boolean isHorizontal() {
		return horizontal;
	}

	public void setHorizontal(boolean isHorizontal) {
		this.horizontal = isHorizontal;
	}

	@Override
	public boolean isMarkerVisible() {
		return markerVisible;
	}

	public void setMarkerVisible(boolean isMarkerVisible) {
		this.markerVisible = isMarkerVisible;
	}

	@Override
	public boolean isMessageVisible() {
		return messageVisible;
	}

	public void setMessageVisible(boolean isMessageVisible) {
		this.messageVisible = isMessageVisible;
	}

	@Override
	public IBPMNShape getChoreographyActivityShape() {
		return choreographyActivityShape;
	}

	public void setChoreographyActivityShape(
			IBPMNShape choreographyActivityShape) {
		this.choreographyActivityShape = choreographyActivityShape;
	}

	@Override
	public boolean isExpanded() {
		return expanded;
	}

}
