/**
 * bpmn-di - BPMN graphical layer domain - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.business.domain.di.api;

import com.ebmwebsourcing.geasytools.diagrameditor.domain.diagramdefinition.interchange.api.IPlane;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.foundation.BaseElementBean;

/**
 * A BPMNPlane can only reference a BaseElement of the types: Process, SubProcess, AdHocSubProcess, Transaction,
 * Collaboration, Choreography or SubChoreography.
 *
 * BPMNPlane element is always owned by a BPMNDiagram and represents the root diagram element of that diagram. The
 * plane represents a 2 dimensional surface with an origin at (0, 0) along the x and y axes with increasing coordinates to the
 * right and bottom. Only positive coordinates are allowed for diagram elements that are nested in a BPMNPlane. This
 * means that the union of all the nested elements' bounds is deemed to be located at the plane's origin point.
 *
 * @author nfleury
 *
 */
public interface IBPMNPlane extends IPlane{

	BaseElementBean getModelElement();
	
}
