/**
 * bpmn-di - BPMN graphical layer domain - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.business.domain.di.impl;

import java.util.LinkedHashSet;

import com.ebmwebsourcing.geasytools.diagrameditor.domain.diagramdefinition.interchange.api.ILabel;
import com.ebmwebsourcing.geasytools.diagrameditor.domain.diagramdefinition.interchange.impl.LabeledShape;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.HasModelManager;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.foundation.IBaseElementBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.foundation.BaseElementBean;
import com.ebmwebsourcing.petalsbpm.business.domain.di.api.IBPMNShape;
import com.ebmwebsourcing.petalsbpm.business.domain.di.api.ParticipantBandKind;

public class BPMNShape extends LabeledShape implements IBPMNShape{
	

	
	private ParticipantBandKind participantBandKind;
	private boolean expanded;
	private boolean horizontal;
	private boolean markerVisible;
	private boolean messageVisible;
	private BPMNShape choreographyActivityShape;
	
	public BPMNShape(){
		super();
	}
	
	
	public IBaseElementBean getModelElement() {
		return (IBaseElementBean) super.getModelElement();
	}
	
	
	public void setModelElement(IBaseElementBean modelElement) {
		super.setModelElement(modelElement);
	}

	public ParticipantBandKind getParticipantBandKind() {
		return participantBandKind;
	}
	
	public void setParticipantBandKind(ParticipantBandKind participantBandKind) {
		this.participantBandKind = participantBandKind;
	}

	public void setExpanded(boolean isExpanded) {
		this.expanded = isExpanded;
	}
	
	public boolean isHorizontal() {
		return horizontal;
	}

	public void setHorizontal(boolean isHorizontal) {
		this.horizontal = isHorizontal;
	}
	
	public boolean isMarkerVisible() {
		return markerVisible;
	}

	public void setMarkerVisible(boolean isMarkerVisible) {
		this.markerVisible = isMarkerVisible;
	}
	
	public boolean isMessageVisible() {
		return messageVisible;
	}

	public void setMessageVisible(boolean isMessageVisible) {
		this.messageVisible = isMessageVisible;
	}
	
	public IBPMNShape getChoreographyActivityShape() {
		return choreographyActivityShape;
	}

	public void setChoreographyActivityShape(BPMNShape choreographyActivityShape) {
		this.choreographyActivityShape = choreographyActivityShape;
	}

	public boolean isExpanded() {
		return expanded;
	}
	
	@Override 
	public HasModelManager getClone() {
		BPMNShape s = new BPMNShape();

		s.setExpanded(this.isExpanded());
		s.setHeight(this.getHeight());
		s.setHorizontal(this.isHorizontal());
		s.setMarkerVisible(this.isMarkerVisible());
		s.setMessageVisible(this.isMessageVisible());
		s.setModelElement(this.getModelElement());
		s.setParticipantBandKind(this.getParticipantBandKind());
		s.setWidth(this.getWidth());
		s.setX(this.getX());
		s.setY(this.getY());
		
		if(this.getOwnedLabels()!=null){
			LinkedHashSet<ILabel> labels = new LinkedHashSet<ILabel>();
			for(ILabel l : this.getOwnedLabels()){
				labels.add((ILabel) l.getClone());
			}
			s.setOwnedLabels(labels);
		}
		
		return s;
	}
}
