/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.bpmndiagram;

import java.util.HashSet;

import com.ebmwebsourcing.geasytools.diagrameditor.api.graphic.IDiagramElementView;
import com.ebmwebsourcing.geasytools.diagrameditor.api.graphic.IDiagramView;
import com.ebmwebsourcing.geasytools.diagrameditor.api.validation.IDiagramViewConformityRule;
import com.ebmwebsourcing.geasytools.diagrameditor.api.validation.IRuleLevel;
import com.ebmwebsourcing.geasytools.diagrameditor.impl.validation.AbstractDiagramViewConformityRule;
import com.ebmwebsourcing.geasytools.diagrameditor.impl.validation.RuleLevel;
import com.ebmwebsourcing.geasytools.geasyui.api.core.IUIElement;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.editormodels.ProcessEditorModel;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.common.IParticipantBean;
import com.ebmwebsourcing.petalsbpm.business.domain.di.api.IBPMNShape;

public class ExecutableProcessRules {

	private HashSet<IDiagramViewConformityRule> rules;
	
	private ProcessPanel processPanel;
	
	public ExecutableProcessRules(ProcessPanel processPanel) {
		
		this.processPanel = processPanel;
		
		this.rules = new HashSet<IDiagramViewConformityRule>();
		this.rules.add(new ProcessMustHaveInterfaces(processPanel));
		
		
	}
	
	public HashSet<IDiagramViewConformityRule> getRules() {
		return rules;
	}

	private IDiagramElementView getExpandedPool(){
		
		
		for(IUIElement el:processPanel.getUIElements().values()){
			
			IDiagramElementView elView = (IDiagramElementView) el;
			
			if ((elView.getDiagramElement().getModelElement() instanceof IParticipantBean)){
				
				if (elView.getDiagramElement() instanceof IBPMNShape){
					
					IBPMNShape shape = (IBPMNShape) elView.getDiagramElement();
					
					if (shape.isExpanded()) return elView;
					
				}
				
			}
			
			
		}
		
		
		return null;
	}
	
	////////////
	//ERRORS
	///////////////////
	
	
	//////////PROCESS MUST HAVE INTERFACES (only if no Expanded Pool Exists)
	private class ProcessMustHaveInterfaces extends AbstractDiagramViewConformityRule {

		public ProcessMustHaveInterfaces(IDiagramView diagramView) {
			super(diagramView);
			
		}

		@Override
		public boolean isConform(IDiagramView diagramView) {
			
			
			if (getExpandedPool()==null){
				
				ProcessEditorModel model = (ProcessEditorModel) processPanel.getEditorModel();
				
				if (model.getInterfaces()==null){
					return false;
				}else{
					
					if (model.getInterfaces().size()==0){
						return false;
					}
				}
				
			}
			
			return true;
		}

		@Override
		public boolean canResolveNonConformity() {
			// TODO Auto-generated method stub
			return false;
		}

		@Override
		public String getResolveConformityDescription() {
			return "Select interfaces implemented by actual Process participant";
		}

		@Override
		public String getRuleDescription() {
			return "Actual Process (Participant) doesn't have any interfaces";
		}

		@Override
		public IRuleLevel getRuleLevel() {
			return RuleLevel.ERROR;
		}

		@Override
		public String getRuleName() {
			return "Intefaces Required";
		}

		@Override
		public void resolveNonConformity() {
			// TODO Auto-generated method stub
			
		}
		
		
		
	}
	
	

}
