/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.bpmndiagram.collaboration;

import java.util.HashSet;

import com.ebmwebsourcing.geasytools.diagrameditor.api.graphic.IDiagramElementView;
import com.ebmwebsourcing.geasytools.diagrameditor.api.validation.IDiagramElementViewConformityRule;
import com.ebmwebsourcing.geasytools.diagrameditor.api.validation.IRuleLevel;
import com.ebmwebsourcing.geasytools.diagrameditor.impl.validation.AbstractDiagramElementViewConformityRule;
import com.ebmwebsourcing.geasytools.diagrameditor.impl.validation.RuleLevel;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.common.IParticipantBean;
import com.ebmwebsourcing.petalsbpm.business.domain.di.api.IBPMNShape;

public class DescriptiveProcessSwimlaneRules {
	
	private Swimlane swimlane;
	private HashSet<IDiagramElementViewConformityRule> rules;
	
	public DescriptiveProcessSwimlaneRules(Swimlane swimlane) {
		
		this.swimlane 	= swimlane;
		this.rules 		= new HashSet<IDiagramElementViewConformityRule>();
		
		if (swimlane instanceof Lane){
			
			this.rules.add(new SwimlaneMustNotBeEmpty(swimlane,"Empty Lane","Actual Lane is empty","Actual Lane doesn't contain any element. Please, add some flow nodes in it"));
			
		}else if (swimlane instanceof Pool){
			
			this.rules.add(new SwimlaneMustNotBeEmpty(swimlane,"Empty Pool","Actual Pool is empty","Actual Pool doesn't contain any Lane. Please, add some Lanes in it"));
		}
		
	}
	
	public HashSet<IDiagramElementViewConformityRule> getRules() {
		return rules;
	}
	
	
	////////////
	//ERRORS
	///////////////////
	
	
	//////////SWIMLANE MUST NOT BE EMPTY (only expanded Pool and Lane)
	private class SwimlaneMustNotBeEmpty extends AbstractDiagramElementViewConformityRule{
		
		private String ruleDescription;
		private String ruleName;
		private String resolveDescription;
		
		public SwimlaneMustNotBeEmpty(
				IDiagramElementView diagramElementView,String ruleName,String ruleDescription,String resolveDescription) {
			super(diagramElementView);
			
			this.ruleName = ruleName;
			this.ruleDescription = ruleDescription;
			this.resolveDescription = resolveDescription;
			
		}

		@Override
		public boolean isConform(IDiagramElementView diagramElementView) {
			
			IBPMNShape shape = (IBPMNShape) diagramElementView.getDiagramElement();
			
			if (shape.getOwnedElements().size()==0) return false;
			
			return true;
		}

		@Override
		public boolean canResolveNonConformity() {
			// TODO Auto-generated method stub
			return false;
		}

		@Override
		public String getResolveConformityDescription() {
			return resolveDescription;
		}

		@Override
		public String getRuleDescription() {
			return ruleDescription;
		}

		@Override
		public IRuleLevel getRuleLevel() {
			return RuleLevel.ERROR;
		}

		@Override
		public String getRuleName() {
			return ruleName;
		}

		@Override
		public void resolveNonConformity() {

		}
		
		
		
		
	}
	
}
