/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.bpmndiagram.collaboration;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;

import com.ebmwebsourcing.geasytools.diagrameditor.api.modeleditor.IEditorModel;
import com.ebmwebsourcing.geasytools.diagrameditor.api.syntax.IDiagramElementSyntaxModelBinder;
import com.ebmwebsourcing.geasytools.diagrameditor.api.validation.IDiagramElementViewConformityRule;
import com.ebmwebsourcing.geasytools.geasysvg.core.impl.Rectangle;
import com.ebmwebsourcing.geasytools.geasysvg.core.impl.SVGElement;
import com.ebmwebsourcing.geasytools.geasyui.api.core.IUIElement;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.IDraggableElement;
import com.ebmwebsourcing.geasytools.geasyui.api.droppable.events.IDropAcceptedEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.droppable.events.IDropRefusedEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.droppable.events.IOutEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.droppable.events.IOverEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.DraggableProxy;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ProcessPanel;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.common.FlowElement;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.dragproxy.api.common.IBPMNDragProxyData;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.editormodels.LaneEditorModel;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.events.EndMessageEvent;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.events.EndNoneEvent;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.events.IntermediateCatchingMessageEvent;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.events.IntermediateCatchingTimerEvent;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.events.IntermediateThrowingMessageEvent;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.events.StartTimerEvent;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.events.StartTopLevelMessageEvent;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.events.StartTopLevelNoneEvent;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.events.TerminateEvent;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.gateways.EventBasedGateway;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.gateways.ExclusiveGateway;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.gateways.ParallelGateway;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.process.activities.CallActivity;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.process.activities.Task;
import com.google.gwt.core.client.GWT;

public class Lane extends Swimlane {
	
	private Rectangle boundary;
	private Rectangle dropZone;
	
 
	
	
	private Pool parentPool;
	private Lane parentLane;
	
	private float width;
	private float height;
	

	
	public Lane(ProcessPanel definitionPanel,String id) {
		super(definitionPanel,id);
	
		this.width 	= Pool.DEFAULT_WIDTH ;
		this.height = Pool.DEFAULT_HEIGHT;

	}
	
	public String getName() {
		return "Lane";
	}
	
	@Override
	public void setWidth(float width) {
		this.width =width;
		this.dropZone.setWidth(width);
		super.setWidth(width);
	}
	
	@Override
	public void setHeight(float height) {
		this.height = height;
		this.dropZone.setHeight(height);
		label.setY(height/2);
		super.setHeight(height);
	}
	
	
	@Override
	protected void init() {
		super.init();

		this.dropZone = this.getDefinitionPanel().getCanvas().createRectangle(0, 0, (Pool.DEFAULT_WIDTH-Pool.LABEL_ZONE_WIDTH), Pool.DEFAULT_HEIGHT);
		this.dropZone.setFillColour("white");

		this.label	  = this.getDefinitionPanel().getCanvas().createText(10, (Pool.DEFAULT_HEIGHT/2), "");
		this.label.rotate(270, false);

		this.getGroup().appendChild(dropZone);
		this.getGroup().appendChild(label);
	}
	
	public LinkedHashMap<String, IUIElement> getFlowElements(){
		return this.getChildrenUIElements();
	}
	
	public void addLane(Lane lane){
		this.addUIElement(lane);
		lane.setParentLane(lane);
	}
	
	public void addFlowElement(FlowElement flowElement){
		this.addUIElement(flowElement);
		flowElement.setParentLane(this);
	}
	
	public LinkedHashMap<String, IUIElement> getLanes() {
		return this.getChildrenUIElements();
	}
	
	
	@Override
	public SVGElement getMainShape() {
		
		if (boundary==null){
			
			boundary = this.getDefinitionPanel().getCanvas().createRectangle(0, 0, (Pool.DEFAULT_WIDTH-Pool.LABEL_ZONE_WIDTH), Pool.DEFAULT_HEIGHT);
			boundary.setFillColour("white");
			boundary.setStokeColour("black");
		
		}
			
		return boundary;
	}


	public HashSet<Class<? extends IDraggableElement>> getAcceptedTypes() {
		
		HashSet<Class<? extends IDraggableElement>> result = new HashSet<Class<? extends IDraggableElement>>();
		
		//actual lane will accept a lane only if there is no child in it
		if (this.getChildrenUIElements().size()==0) result.add(Lane.class);
		
		//Activities
		result.add(Task.class);
		result.add(CallActivity.class);
		
		
		//gateways
		result.add(ExclusiveGateway.class);
		result.add(ParallelGateway.class);
		result.add(EventBasedGateway.class);
		
		//Events
		
		//start
		result.add(StartTopLevelNoneEvent.class);
		result.add(StartTopLevelMessageEvent.class);
		result.add(StartTimerEvent.class);
		
		//intermediate
		result.add(IntermediateThrowingMessageEvent.class);
		result.add(IntermediateCatchingMessageEvent.class);
		result.add(IntermediateCatchingTimerEvent.class);
		
		//end
		result.add(EndNoneEvent.class);
		result.add(EndMessageEvent.class);
		result.add(TerminateEvent.class);
		
		
		
		return result;
	}


//	public IPoint getNorthWestPoint() {
//		Point p  = new Point(this.getAbsoluteLeft(), this.getAbsoluteTop());
//
//		return p;
//	}
//
//	public IPoint getSouthEastPoint() {
//		
//		Point p = new Point(this.getAbsoluteLeft()+this.getWidth(), this.getAbsoluteTop()+this.getHeight());
//
//		return p;
//	}

	public void onDropAccepted(IDropAcceptedEvent event) {
//		System.out.println("Drop on Lane accepted");
		this.dropZone.setFillColour("white");
	}

	public void onDropRefused(IDropRefusedEvent event) {
		

		
	}
	
	

	public void onOut(IOutEvent event) {
		
		this.dropZone.setFillColour("white");

	}

	public void onOver(IOverEvent event) {
		
//		System.out.println("Lane has something OVER");
		
		
		
		if (event.getDraggableElement() instanceof Lane){
			
			this.dropZone.setFillColour("blue");
			
		}else if (event.getDraggableElement() instanceof DraggableProxy){
			
			DraggableProxy proxy 			= (DraggableProxy) event.getDraggableElement();
			
			IBPMNDragProxyData bpmndata 	= (IBPMNDragProxyData) proxy.getHasDraggableElementProxy();
			
			if (bpmndata.getBPMNElementType()==Task.class){
				this.dropZone.setFillColour("blue");
			}else{
				this.dropZone.setFillColour("red");
			}
			
			
		}else{
			
			this.dropZone.setFillColour("white");
			
		}

	}



	public IEditorModel getEditorModel() {
		
		if (editorModel==null){
			this.editorModel = GWT.create(LaneEditorModel.class);
		}
		return editorModel;
	}

//	public HashSet<IDiagramElementGraphicState> getStates() {
//		// TODO Auto-generated method stub
//		return null;
//	}

	 @Override
	public void refresh() {
		 	
		 	//use the same one as pool
			float x = Pool.LABEL_ZONE_WIDTH;
			float y = 0;
			float maxWidth = 0;
			for (Iterator<IUIElement> it = getLanes().values().iterator(); it.hasNext();) {
			      
				IUIElement el = it.next();
				if (el instanceof Lane){
					if (el.getWidth()>maxWidth){
						maxWidth = el.getWidth();
					}
					
					el.setRelativeX(x);
					el.setRelativeY(y);
					
					y = y + el.getHeight();			
			   
				}
			}


			if (y==0) y=this.height;
			if (maxWidth==0) maxWidth=this.width;
				
			this.setWidth(maxWidth);
			
			this.setHeight(y);
		
	}
	
	 public void setParentPool(Pool parentPool) {
		this.parentPool = parentPool;
	}
	 
	public Pool getParentPool() {
		return parentPool;
	}
	
	public void setParentLane(Lane parentLane) {
		this.parentLane = parentLane;
	}
	
	public Lane getParentLane() {
		return parentLane;
	}

	public IDiagramElementSyntaxModelBinder getSyntaxModelBinder() {
		return new LaneSyntaxModelBinder();
	}





	 
}
