/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.bpmndiagram.common;

import java.util.HashMap;
import java.util.HashSet;

import com.ebmwebsourcing.geasytools.diagrameditor.api.graphic.IDiagramElementGraphicState;
import com.ebmwebsourcing.geasytools.diagrameditor.api.modeleditor.IEditorModel;
import com.ebmwebsourcing.geasytools.diagrameditor.api.modeleditor.IEditorView;
import com.ebmwebsourcing.geasytools.diagrameditor.domain.diagramdefinition.interchange.api.IDiagramElement;
import com.ebmwebsourcing.geasytools.diagrameditor.domain.diagramdefinition.interchange.api.IMainModelElement;
import com.ebmwebsourcing.geasytools.geasysvg.core.impl.Group;
import com.ebmwebsourcing.geasytools.geasysvg.core.impl.SVGDocument;
import com.ebmwebsourcing.geasytools.geasysvg.core.impl.SVGElement;
import com.ebmwebsourcing.geasytools.geasysvg.core.impl.Text;
import com.ebmwebsourcing.geasytools.geasyui.api.core.Direction;
import com.ebmwebsourcing.geasytools.geasyui.api.core.IUIElement;
import com.ebmwebsourcing.geasytools.geasyui.api.core.events.IBoundsUpdateHandler;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IAcceptedAfterDropEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IAcceptedBeforeDropEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IDragMoveEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IDragStartEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IDragStopEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IRefusedAfterDropEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IRefusedBeforeDropEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.core.Point;
import com.ebmwebsourcing.geasytools.geasyui.impl.core.events.PositionChangeEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.core.events.SizeChangeEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.DragHandler;
import com.ebmwebsourcing.geasytools.geasyui.impl.droppable.DropHandler;
import com.ebmwebsourcing.geasytools.geasyui.impl.droppable.DroppableDraggable;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder.AbstractUITemplate;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ProcessPanel;
import com.ebmwebsourcing.petalsbpm.business.domain.di.impl.BPMNShape;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.Widget;

/**
 * Common type for every BPMN elements. 
 * This element can be selected, dragged and other 
 * draggable elements can be dropped on it.
 * 
 * @author nfleury
 *
 */
public abstract class CoreBPMNElement extends DroppableDraggable implements IBPMNElement,DragHandler,DropHandler{
	

	private ProcessPanel definitionPanel;
	
	//SVG
	private Group group;
	protected Text label;
	//Models
	private BPMNShape bpmnShape;
	protected IEditorModel editorModel;
	
	private IEditorView editorView;
	
	private IMainModelElement mainModel;
	
	private AbstractUITemplate formTemplate;
	
	public CoreBPMNElement(ProcessPanel definitionPanel, String id) {
		super(definitionPanel,id);
		

		
		this.addDragHandler(this);


		//this.addDropHandler(new DropIndicatorHandler(this));		

	
		//Every bpmn element is contained at least in a group
		init();


	}
	
	public void addBoundUpdateHandler(IBoundsUpdateHandler handler) {
		handlerManager.addHandler(SizeChangeEvent.TYPE, handler);
		handlerManager.addHandler(PositionChangeEvent.TYPE, handler);
	}
	
	@Override
	public void removeFromParent() {
		super.removeFromParent();
		group.remove();
	}
	
	public void setLabel(String text){
		this.label.setText(text);
	}
	
	public IEditorView getEditorView() {
		return editorView;
	}
	
	public void setEditorView(IEditorView editorView) {
		this.editorView = editorView;
	}
	
	public IDiagramElement getDiagramElement() {
		
		if (bpmnShape==null){
			bpmnShape = GWT.create(BPMNShape.class);
		}
		
		return bpmnShape;
	}
	
	public HashSet<IDiagramElementGraphicState> getStates() {
		
		HashSet<IDiagramElementGraphicState> states = new HashSet<IDiagramElementGraphicState>();
		
		CommonStates cs = new CommonStates();
	
		states.add(cs.new NameState());
		
		return states;
	}
	
	/**
	 * On initialization main shape is automatically added to
	 * group
	 */
	protected void init(){
		
		SVGDocument doc = (SVGDocument) this.getMainShape().getCanvas();

		this.getGroup().appendChild(getMainShape());
		
	}
	
	
	public ProcessPanel getDefinitionPanel() {
		return ((ProcessPanel)getUIPanel());
	}
	
	
	public Group getGroup() {
		
		if (group==null){
			
			this.group 		= (Group) ((ProcessPanel)getUIPanel()).getCanvas().createGroup();
			this.group.getX();
			this.group.getY();
			this.group.getAbsoluteLeft();
			this.group.getAbsoluteTop();
		
		}
		
		return group;
	}
	
	
	@Override
	public Widget getMainWidget() {
		return getGroup();
	}
	
	/**
	 * Main shape represents the boundary of the current artifact 
	 * @return
	 */
	public abstract SVGElement getMainShape();
	
	
	public abstract void refresh();


	public float getHeight() {
		return this.getMainShape().getHeight();
	}

	
	public float getWidth() {
		return this.getMainShape().getWidth();
	}
	
	public String getId() {
		return this.getElement().getId();
	}

	public HashMap<Direction, Point> getIntersectionPoints() {
		HashMap<Direction,Point> points = new HashMap<Direction,Point>();
		
		//top left point
		Point tlp = new Point(getAbsoluteLeft(), getAbsoluteTop());

		//top top right point
		Point trp = new Point(getAbsoluteLeft()+getWidth(),getAbsoluteTop());
		
		//btm left point
		Point blp = new Point(getAbsoluteLeft(),getAbsoluteTop()+getHeight());
		
		//btm top right point
		
		Point brp = new Point(getAbsoluteLeft()+getWidth(), getAbsoluteTop()+getHeight());

		//middle point
		Point mp = new Point(getAbsoluteLeft()+(getWidth()/2),getAbsoluteTop()+(getHeight()/2));
		
		points.put(Direction.NW, tlp);
		points.put(Direction.NE,trp);
		points.put(Direction.SW,blp);
		points.put(Direction.SE,brp);
		points.put(Direction.CENTER, mp);
		
		return points;
	}



	
	public float getRelativeX() {
		return this.getAbsoluteLeft()- this.getContainer().getAbsoluteLeft();
	}


	public float getRelativeY() {
		return this.getAbsoluteTop() - this.getContainer().getAbsoluteTop();
	}


	@Override
	public int getAbsoluteLeft() {
		return this.getGroup().getAbsoluteLeft();
	}
	
	
	@Override
	public int getAbsoluteTop() {
		return this.getGroup().getAbsoluteTop();
	}


	public void setHeight(float height) {
		this.getMainShape().setHeight(height);
	}

	
	public void setRelativeX(float x) {
		this.group.setX(x);
	}
	
	
	public void setRelativeY(float y) {
		this.group.setY(y);
	}


	public void setWidth(float width) {
		this.getMainShape().setWidth(width);
	}




	public HashSet<Class<? extends IUIElement>> getDraggedTypes() {
		HashSet<Class<? extends IUIElement>> draggedTypes =  new HashSet<Class<? extends IUIElement>>();
		
		draggedTypes.add(this.getClass());
		
		return draggedTypes;
	}


	

	public void onAcceptedAfterDrop(IAcceptedAfterDropEvent event) {
		// TODO Auto-generated method stub
		
	}
	public void onAcceptedBeforeDrop(IAcceptedBeforeDropEvent event) {
		// TODO Auto-generated method stub
		
	}
	
	public void onRefusedAfterDrop(IRefusedAfterDropEvent event) {
		// TODO Auto-generated method stub
		
	}
	
	public void onRefusedBeforeDrop(IRefusedBeforeDropEvent event) {
		// TODO Auto-generated method stub
		
	}

	public void onMove(IDragMoveEvent event) {
		
		this.getGroup().toFront();
		
	}

	public void onStart(IDragStartEvent event) {
		
		this.getGroup().toFront();

	}

	public void onStop(IDragStopEvent event) {
		
		
		
	}

	public void hide() {
		// TODO Auto-generated method stub
		
	}



	public void show() {
		// TODO Auto-generated method stub
		
	}



	public void toBack() {
		// TODO Auto-generated method stub
		
	}



	public void toFront() {
		// TODO Auto-generated method stub
		
	}
	

	public IMainModelElement getMainModel(){
		return this.getDefinitionPanel().getMainModel();
	}
	
	@Override
	public void setFormTemplate(AbstractUITemplate formTemplate) {
		this.formTemplate = formTemplate;
		
	}
	
	@Override
	public AbstractUITemplate getFormTemplate() {
		return formTemplate;
	}
	
}
