/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.bpmndiagram.common;

import java.util.LinkedHashMap;

import com.ebmwebsourcing.geasytools.geasyui.api.core.IContainer;
import com.ebmwebsourcing.geasytools.geasyui.api.core.IContainerDefaultHandler;
import com.ebmwebsourcing.geasytools.geasyui.api.core.IUIElement;
import com.ebmwebsourcing.geasytools.geasyui.api.core.IUIElementFactory;
import com.ebmwebsourcing.geasytools.geasyui.api.core.events.IContainerHandler;
import com.ebmwebsourcing.geasytools.geasyui.impl.core.ContainerDefaultHandler;
import com.ebmwebsourcing.geasytools.geasyui.impl.core.events.AddUIElementEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.core.events.RemoveUIElementEvent;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ProcessPanel;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.collaboration.CollapsedPool;

public abstract class CoreContainer extends CoreBPMNElement implements IContainer{
	
	private LinkedHashMap<String, IUIElement> uiElements;
	private IContainerDefaultHandler defaultHandler;
	
	
	public CoreContainer(ProcessPanel definitionPanel,String id) {
		super(definitionPanel, id);
		
		this.uiElements 	= new LinkedHashMap<String, IUIElement>();
		
		if (this instanceof CollapsedPool==false){
			this.defaultHandler = new ContainerDefaultHandler(this, definitionPanel);
			this.defaultHandler.attachDefaultHandlers();
		}
		
		this.addDropHandler(this);		
	}


	public void addUIElement(IUIElement uiElement) {
		
		if (uiElement instanceof CoreBPMNElement){
			
			CoreBPMNElement el = (CoreBPMNElement) uiElement;
			
			uiElement.setContainer(this);
			this.uiElements.put(uiElement.getId(), uiElement);
			this.getGroup().appendChild(el.getGroup());
			el.getGroup().setContainer(this.getGroup());
			this.fireEvent(new AddUIElementEvent(uiElement));
			uiElement.refresh();
		
		}
		
	}

	public LinkedHashMap<String, IUIElement> getChildrenUIElements() {
		return this.uiElements;
	}
	
	public void addContainerHandler(IContainerHandler handler) {
		handlerManager.addHandler(AddUIElementEvent.TYPE, handler);
		handlerManager.addHandler(RemoveUIElementEvent.TYPE, handler);
	}
	
	public void removeAllChildren() {
		this.uiElements.clear();
	}

	public void removeChildElement(IUIElement uiElement) {
		this.uiElements.remove(uiElement.getId());
		this.fireEvent(new RemoveUIElementEvent(uiElement));
	}
	
	public IContainerDefaultHandler getContainerDefaultHandler() {
		return defaultHandler;
	}


	public IUIElementFactory getElementFactory() {
		return this.getUIPanel().getElementFactory();
	}	
	
	public int getScrollLeft() {
		// TODO Auto-generated method stub
		return 0;
	}
	
	public int getScrollTop() {
		// TODO Auto-generated method stub
		return 0;
	}
	
	public int getClientHeight() {
		// TODO Auto-generated method stub
		return 0;
	}
	
	public int getClientWidth() {
		// TODO Auto-generated method stub
		return 0;
	}
	
}
