/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.bpmndiagram.connectors;

import java.util.HashSet;

import com.ebmwebsourcing.geasytools.diagrameditor.api.graphic.IDiagramElementGraphicState;
import com.ebmwebsourcing.geasytools.diagrameditor.api.modeleditor.IEditorModel;
import com.ebmwebsourcing.geasytools.diagrameditor.api.syntax.IDiagramElementSyntaxModelBinder;
import com.ebmwebsourcing.geasytools.diagrameditor.api.validation.IDiagramElementViewConformityRule;
import com.ebmwebsourcing.geasytools.geasysvg.core.impl.Marker;
import com.ebmwebsourcing.geasytools.geasysvg.core.impl.Path;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.IUIPanel;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder.AbstractUITemplate;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.BPMNElementsPath;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ProcessPanel;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.common.connector.ConnectorElement;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.connectors.ConnectorCommonStates.NameState;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.editormodels.SequenceFlowEditorModel;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.modeleditor.template.SequenceFlowFormTemplate;
import com.google.gwt.core.client.GWT;

public class SequenceFlow extends ConnectorFlow{

	private SequenceFlowType type;
	
	private Marker conditionalFlowStartMarker;
	private Marker defaultStartMarker;
	private Marker noneStartMarker;
	
	
	private SequenceFlowEditorModel editorModel;
	

	
	public SequenceFlow(IUIPanel uipanel, String id) {
		super(uipanel, id);
		
		

		
		Marker sequenceFlowEndMarker = ((ProcessPanel)uipanel).getCanvas().createMarker(id+"-sequenceFlowEnd");
		Path sequenceFlowArrow = ((ProcessPanel)uipanel).getCanvas().createPath("M 0 1 L 15 6 L 0 11z", 0, 0);
		sequenceFlowArrow.setFillColour("black");
		sequenceFlowArrow.getElement().setAttribute("transform", "scale(0.5)");
		
		sequenceFlowEndMarker.setRefX(7);
		sequenceFlowEndMarker.setRefY(3);
		sequenceFlowEndMarker.appendChild(sequenceFlowArrow);

		sequenceFlowEndMarker.setHeight(10);
		sequenceFlowEndMarker.setWidth(10);
		sequenceFlowEndMarker.setOrient("auto");

		this.linearPath.setMarkerEnd(sequenceFlowEndMarker);
		this.linearPath.getElement().setAttribute("stroke-width", "2");
		////CONDITIONAL FLOW
		Path conditionalFlowPath = ((ProcessPanel) this.getUIPanel()).getCanvas().createPath(
				BPMNElementsPath.CONNECTOR_CONDITIONAL_SEQUENCE_FLOW, 0, 0);
		conditionalFlowPath.setFillColour("white");
		conditionalFlowPath.getElement().setAttribute("transform", "scale(0.5)");

		conditionalFlowStartMarker = ((ProcessPanel) this.getUIPanel()).getCanvas().createMarker(
		id+"conditionalFlowStart");
		conditionalFlowStartMarker.setRefY(2.5);
		conditionalFlowStartMarker.appendChild(conditionalFlowPath);
		conditionalFlowStartMarker.setHeight(200);
		conditionalFlowStartMarker.setWidth(200);
		conditionalFlowStartMarker.setOrient("auto");
		
		
		
		/////DEFAULT FLOW
		Path defaultFlowPath = ((ProcessPanel) this.getUIPanel()).getCanvas().createPath(
				BPMNElementsPath.CONNECTOR_DEFAULT_SEQUENCE_FLOW, 0, 0);
		defaultFlowPath.getElement().setAttribute("transform", "scale(0.5)");
		
		defaultStartMarker = ((ProcessPanel) this.getUIPanel()).getCanvas().createMarker(
		id+"defaultFlowStartMarker");
		defaultStartMarker.setRefY(2);
		defaultStartMarker.appendChild(defaultFlowPath);
		defaultStartMarker.setHeight(200);
		defaultStartMarker.setWidth(200);
		defaultStartMarker.setOrient("auto");
		
		
		noneStartMarker = ((ProcessPanel) this.getUIPanel()).getCanvas().createMarker(
		id+"noneFlowStartMarker");
		
		this.type = SequenceFlowType.NONE;
		processType();
	}
	
	public String getName() {
		return "Sequence Flow";
	}
	
	public void setType(SequenceFlowType type){
		this.type = type;
		processType();
	}
	
	
	public SequenceFlowType getType() {
		return type;
	}


	public HashSet<IDiagramElementGraphicState> getStates() {
		HashSet<IDiagramElementGraphicState> states = new HashSet<IDiagramElementGraphicState>();

		states.addAll(super.getStates());
		states.addAll(new SequenceFlowStates().getStates());
		
		return states;
	}
	
	private void processType(){
		
		if (this.type==SequenceFlowType.CONDITIONAL){
			
			this.linearPath.setMarkerStart(conditionalFlowStartMarker);	
			
		}else if (this.type==SequenceFlowType.DEFAULT){
			
			this.linearPath.setMarkerStart(defaultStartMarker);
			
		}else if (this.type==SequenceFlowType.NONE){
			
			this.linearPath.setMarkerStart(noneStartMarker);
			
		}
		
	
	}


	public IEditorModel getEditorModel() {

		if (editorModel==null){
			this.editorModel = GWT.create(SequenceFlowEditorModel.class);
		}
		
		return editorModel;
	}





	public IDiagramElementSyntaxModelBinder getSyntaxModelBinder() {

		return new SequenceFlowSyntaxModelBinder();
	}



}
