/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.bpmndiagram.dragproxy.impl.connectors;


import com.ebmwebsourcing.geasytools.geasyui.api.core.IUIElement;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.IHasDragProxyData;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.IUIPanel;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.connectors.SequenceFlow;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.dragproxy.impl.common.AbstractBPMNDragProxy;

public class SequenceFlowDragProxy extends AbstractBPMNDragProxy{

	public SequenceFlowDragProxy(IUIPanel uipanel) {
		super(uipanel);
	
	}

	@Override
	protected String getDescription() {
		return "A sequence flow indicates the order in which the activities will be performed";
	}

	@Override
	protected String getBigIcon() {
		return "images/ico/bpmn/connectors/sequence_flow.png";
	}

	@Override
	protected String getLabel() {
		return "Sequence Flow";
	}

	public IHasDragProxyData getData() {
		
		return null;
	}

	public Class<? extends IUIElement> getIUIElementType() {
		return SequenceFlow.class;
	}

	@Override
	protected String getSmallIcon() {
		return "images/ico/bpmn/connectors/sequence_flow16x16.png";
	}

}
