/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.bpmndiagram.editormodels;

import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.Constants.TaskType;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.common.IMessageBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.service.IOperationBean;

public class TaskEditorModel extends ActivityEditorModel{
	
	private TaskType taskType = TaskType.NONE;
	
	//Send  + Receive + Service
	private IMessageBean message;//not in service
	private IOperationBean operation;
	private String implementation;
	
	private Boolean instantiate; //receive only
	
	public TaskEditorModel() {
		super();
	}
	
	public void setTaskType(TaskType taskType) {
		this.taskType = taskType;
	}
	
	
	public TaskType getTaskType() {
		return taskType;
	}
	
	public IMessageBean getMessage() {
		return message;
	}
	
	public void setMessage(IMessageBean message) {
		this.message = message;
	}
	
	public IOperationBean getOperation() {
		return operation;
	}
	
	public void setOperation(IOperationBean operation) {
		this.operation = operation;
	}
	
	public String getImplementation() {
		return implementation;
	}
	
	public void setImplementation(String implementation) {
		this.implementation = implementation;
	}
	
	public Boolean getInstantiate() {
		return instantiate;
	}
	
	public void setInstantiate(Boolean instantiate) {
		this.instantiate = instantiate;
	}
	
}
