/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.bpmndiagram.events;

import java.util.HashSet;

import com.ebmwebsourcing.geasytools.diagrameditor.api.syntax.IDiagramElementSyntaxModelBinder;
import com.ebmwebsourcing.geasytools.diagrameditor.api.validation.IDiagramElementViewConformityRule;
import com.ebmwebsourcing.geasytools.geasysvg.core.impl.Circle;
import com.ebmwebsourcing.geasytools.geasysvg.core.impl.SVGElement;
import com.ebmwebsourcing.geasytools.geasyui.api.contextualmenu.IHasDragProxyContextualMenu;
import com.ebmwebsourcing.geasytools.geasyui.api.contextualmenu.events.IDragProxyContextualMenuHandler;
import com.ebmwebsourcing.geasytools.geasyui.api.core.Direction;
import com.ebmwebsourcing.geasytools.geasyui.impl.contextualmenu.DragProxyContextualMenu;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.events.ProxyAcceptedAfterDropEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.events.ProxyAcceptedBeforeDropEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.events.ProxyDragMoveEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.events.ProxyDragStartEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.events.ProxyDragStopEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.events.ProxyRefusedAfterDropEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.events.ProxyRefusedBeforeDropEvent;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ProcessPanel;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.common.ConnectableFlowElement;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.common.ContextualMenuHandler;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.common.connector.ConnectionMode;

public abstract class Event extends ConnectableFlowElement implements IHasDragProxyContextualMenu{

	private Circle circle;
	
	public Event(ProcessPanel definitionPanel, String id) {
		super(definitionPanel, id, ConnectionMode.MIDDLES);
	
		DragProxyContextualMenu dpm = new DragProxyContextualMenu(this);
		
		this.addContextualMenuHandler(new ContextualMenuHandler(this));
	}

	
	@Override
	protected void init() {
		super.init();
		
		this.label = this.getDefinitionPanel().getCanvas().createText(0, this.getHeight(), "");
		getGroup().appendChild(label);
	}
	
	
	@Override
	public SVGElement getMainShape() {
		
		if (circle==null){
			
			this.circle = this.getDefinitionPanel().getCanvas().createCircle(0, 0, 15);
			this.circle.setFillColour("white");
			this.circle.setStokeColour("white");
		
		}
			
		
		return circle;
	}

	@Override
	public int getAbsoluteLeft() {
		return super.getAbsoluteLeft()-15;
	}
	
	@Override
	public int getAbsoluteTop() {
		return super.getAbsoluteTop()-15;
	}
	
	@Override
	public void setRelativeX(float x) {
		super.setRelativeX(x+15);
	}
	
	@Override
	public void setRelativeY(float y) {
		super.setRelativeY(y+15);
	}
	
	public void addContextualMenuHandler(IDragProxyContextualMenuHandler handler) {
		handlerManager.addHandler(ProxyDragStartEvent.TYPE, handler);
		handlerManager.addHandler(ProxyDragMoveEvent.TYPE, handler);
		handlerManager.addHandler(ProxyDragStopEvent.TYPE, handler);
		handlerManager.addHandler(ProxyAcceptedBeforeDropEvent.TYPE, handler);
		handlerManager.addHandler(ProxyRefusedBeforeDropEvent.TYPE, handler);
		handlerManager.addHandler(ProxyAcceptedAfterDropEvent.TYPE, handler);
		handlerManager.addHandler(ProxyRefusedAfterDropEvent.TYPE, handler);	
	}
	
	public IDiagramElementSyntaxModelBinder getSyntaxModelBinder() {
		return new EventSyntaxModelBinder(this);
	}
	
	public Direction getMenuDirection() {
		// TODO Auto-generated method stub
		return null;
	}
	
	public HashSet<IDiagramElementViewConformityRule> getConformityRules() {
		HashSet<IDiagramElementViewConformityRule> rules = new HashSet<IDiagramElementViewConformityRule>();
		
		DescriptiveProcessEventValidationRules descRules = new DescriptiveProcessEventValidationRules(this);
		
		rules.addAll(descRules.getRules());
		
		if (getDefinitionPanel().isExecutableProcess()){
			ExecutableProcessEventValidationRules dr = new ExecutableProcessEventValidationRules(this);
			rules.addAll(dr.getRules());			
		}

		
		return rules;
	}
	
}
