/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.bpmndiagram.events;

import java.util.HashSet;

import com.ebmwebsourcing.geasytools.diagrameditor.api.graphic.IDiagramElementView;
import com.ebmwebsourcing.geasytools.diagrameditor.api.validation.IDiagramElementViewConformityRule;
import com.ebmwebsourcing.geasytools.diagrameditor.api.validation.IRuleLevel;
import com.ebmwebsourcing.geasytools.diagrameditor.impl.validation.AbstractDiagramElementViewConformityRule;
import com.ebmwebsourcing.geasytools.diagrameditor.impl.validation.RuleLevel;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.event.definition.IMessageEventDefinitionBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.event.definition.ITimerEventDefinitionBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.event.CatchEventBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.event.EventBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.event.ThrowEventBean;

public class ExecutableProcessEventValidationRules {
	
	private Event event;
	
	public ExecutableProcessEventValidationRules(Event event) {
		
		this.event = event;
		
	}
	
	public HashSet<IDiagramElementViewConformityRule> getRules(){
		
		HashSet<IDiagramElementViewConformityRule> result = new HashSet<IDiagramElementViewConformityRule>();
		
		if (event instanceof StartTopLevelMessageEvent || 
			event instanceof IntermediateCatchingMessageEvent ||
			event instanceof IntermediateThrowingMessageEvent ||
			event instanceof EndMessageEvent
			){
			
			result.add(new MessageBasedEventMustHaveMessageDefinition(event));
			
		}
		
		
		if (event instanceof StartTimerEvent ||
			event instanceof IntermediateCatchingTimerEvent){
			
			result.add(new TimerBasedEventMustHaveTimerEventDefinition());
			
		}
		
		
		return result;
	}
	
	///////////////////////////MESSAGE BASED EVENTS////////////////////////////////
	
	private class MessageBasedEventMustHaveMessageDefinition extends AbstractDiagramElementViewConformityRule implements IDiagramElementViewConformityRule {
		
		private IDiagramElementView diagramElementView;
		
		public MessageBasedEventMustHaveMessageDefinition(IDiagramElementView diagramElementView) {
		 super(diagramElementView);
		}
		

		@Override
		public boolean isConform(IDiagramElementView diagramElementView) {
			

			
			EventBean eventBean = (EventBean) diagramElementView.getDiagramElement().getModelElement();
			
			//Catch Message
			if (eventBean instanceof CatchEventBean){
				
				CatchEventBean catchEventBean = (CatchEventBean) eventBean;
				
				if (catchEventBean.getTriggers().size()==1){
					
					if (catchEventBean.getTriggers().get(0) instanceof IMessageEventDefinitionBean) return true;
					
				}else {
					return false;
				}
			
			//Throw Message	
			}else if (eventBean instanceof ThrowEventBean){
				
				ThrowEventBean throwEventBean = (ThrowEventBean) eventBean;
				
				if (throwEventBean.getResults().size()==1){
					
					if (throwEventBean.getResults().get(0) instanceof IMessageEventDefinitionBean) return true;
					
				}else {
					return false;
				}
				

			}
			
			return false;
		}

		@Override
		public boolean canResolveNonConformity() {
			// TODO Auto-generated method stub
			return false;
		}

		@Override
		public String getResolveConformityDescription() {
			return "Assign a Message Event Definition to actual event";
		}

		@Override
		public String getRuleDescription() {
			return "Actual event doesn't have any Message Event Definition associated to it ";
		}

		@Override
		public IRuleLevel getRuleLevel() {
			return RuleLevel.ERROR;
		}

		@Override
		public String getRuleName() {
			return "Message based events must have an assigned Message Event Definition";
		}

		@Override
		public void resolveNonConformity() {
			// TODO Auto-generated method stub
			
		}
		
		
		
	}
	
	
	///////////////////////////TIMER BASED EVENTS////////////////////////////////
	
	private class TimerBasedEventMustHaveTimerEventDefinition implements IDiagramElementViewConformityRule {

		private IDiagramElementView diagramElementView;
		
		@Override
		public IDiagramElementView getNonConformElement() {
			return diagramElementView;
		}

		@Override
		public boolean isConform(IDiagramElementView diagramElementView) {
			
			this.diagramElementView = diagramElementView;
			
			EventBean eventBean = (EventBean) diagramElementView.getDiagramElement().getModelElement();
			
			//Catch Message
			if (eventBean instanceof CatchEventBean){
				
				CatchEventBean catchEventBean = (CatchEventBean) eventBean;
				
				if (catchEventBean.getTriggers().size()==1){
					
					if (catchEventBean.getTriggers().get(0) instanceof ITimerEventDefinitionBean) return true;
					
				}else {
					return false;
				}
			
			//Throw Message	
			}else if (eventBean instanceof ThrowEventBean){
				
				ThrowEventBean throwEventBean = (ThrowEventBean) eventBean;
				
				if (throwEventBean.getResults().size()==1){
					
					if (throwEventBean.getResults().get(0) instanceof ITimerEventDefinitionBean) return true;
					
				}else {
					return false;
				}
				

			}
			
			
			return false;
		}

		@Override
		public boolean canResolveNonConformity() {
			// TODO Auto-generated method stub
			return false;
		}

		@Override
		public String getResolveConformityDescription() {
			return "Assign a Timer Event Definition to actual event";
		}

		@Override
		public String getRuleDescription() {
			return "Actual event doesn't have any Timer Event Definition associated to it";
		}

		@Override
		public IRuleLevel getRuleLevel() {
			return RuleLevel.ERROR;
		}

		@Override
		public String getRuleName() {
			return "Timer based events must have an assigned Timer Event Definition";
		}

		@Override
		public void resolveNonConformity() {
			// TODO Auto-generated method stub
			
		}
		
		
	}
	
	
	

	
	
	
	
	
	
}
