/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.bpmndiagram.events;

import java.util.HashSet;
import java.util.LinkedHashSet;

import com.ebmwebsourcing.geasytools.diagrameditor.api.modeleditor.IEditorModel;
import com.ebmwebsourcing.geasytools.diagrameditor.api.validation.IDiagramElementViewConformityRule;
import com.ebmwebsourcing.geasytools.geasysvg.core.impl.Path;
import com.ebmwebsourcing.geasytools.geasyui.api.connectable.IConnectableElementDefaulHandlers;
import com.ebmwebsourcing.geasytools.geasyui.api.contextualmenu.IHasMenuDragProxy;
import com.ebmwebsourcing.geasytools.geasyui.api.droppable.events.IDropRefusedEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.droppable.events.IOutEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.droppable.events.IOverEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.connectable.ConnectableElementDefaultHandlers;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.BPMNElementsPath;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ProcessPanel;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.dragproxy.impl.connectors.MessageFlowMenuDragProxy;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.editormodels.MessageEventEditorModel;
import com.google.gwt.core.client.GWT;

public class IntermediateThrowingMessageEvent extends IntermediateEvent {
	
	private Path mainPath;


	private ConnectableElementDefaultHandlers defaultHandlers;
	
	private MessageEventEditorModel editorModel;
	

	
	public IntermediateThrowingMessageEvent(ProcessPanel definitionPanel, String id) {
		super(definitionPanel, id);
		this.defaultHandlers	= new ConnectableElementDefaultHandlers(this);
		this.defaultHandlers.attachDefaultHandlers();

	}

	@Override
	protected void init() {
		super.init();
		mainPath = this.getDefinitionPanel().getCanvas().createPath(BPMNElementsPath.EVENT_INTERMEDIATE_THROWING_MESSAGE, -15, -15);
		mainPath.setFillColour("#17479E");
		mainPath.setStokeColour("#17479E");
		getGroup().appendChild(mainPath);
		mainPath.translate(-15, -15);
	}
	

	public String getName() {
		return "Intermediate Throwing Message Event";
	}


	public IConnectableElementDefaulHandlers getDefaultHandlers() {
		// TODO Auto-generated method stub
		return null;
	}



	public IEditorModel getEditorModel() {
		
		if (editorModel==null){
			this.editorModel = GWT.create(MessageEventEditorModel.class);
		}
		
		return editorModel;
	}


	public void onDropRefused(IDropRefusedEvent event) {
		// TODO Auto-generated method stub

	}

	public void onOut(IOutEvent event) {
		// TODO Auto-generated method stub

	}

	public void onOver(IOverEvent event) {
		// TODO Auto-generated method stub

	}

	@Override
	public LinkedHashSet<IHasMenuDragProxy> getDragProxies() {
		
		LinkedHashSet<IHasMenuDragProxy> result = new LinkedHashSet<IHasMenuDragProxy>();

		MessageFlowMenuDragProxy m = new MessageFlowMenuDragProxy(getUIPanel());
		m.setSmallIcon(true);
		m.setLabelVisible(false);
		
		result.addAll(super.getDragProxies());
		
		result.add(m);
		
		return result;		
	}




}
