/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.bpmndiagram.gateways;


import com.ebmwebsourcing.geasytools.diagrameditor.api.graphic.IDiagramElementGraphicFactory;
import com.ebmwebsourcing.geasytools.diagrameditor.api.graphic.IDiagramElementView;
import com.ebmwebsourcing.geasytools.diagrameditor.domain.diagramdefinition.interchange.api.IDiagramElement;
import com.ebmwebsourcing.geasytools.geasyui.api.core.IUIElement;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.IHasDragProxy;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ProcessPanel;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.editormodels.EventBasedGatewayEditorModel;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.editormodels.ExclusiveGatewayEditorModel;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.editormodels.ParallelGatewayEditorModel;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.modeleditor.template.EventBasedGatewayFormTemplate;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.modeleditor.template.ExclusiveGatewayFormTemplate;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.modeleditor.template.ParallelGatewayFormTemplate;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.gateway.EventBasedGatewayBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.gateway.ExclusiveGatewayBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.gateway.ParallelGatewayBean;
import com.google.gwt.user.client.DOM;

public class GatewayFactory implements IDiagramElementGraphicFactory{
	
	private ProcessPanel definitionPanel;
	
	public GatewayFactory(ProcessPanel definitionPanel) {
		this.definitionPanel = definitionPanel;
	}

	public Gateway getGateway(IHasDragProxy bpmndragproxydata) {
		
		
		if (bpmndragproxydata.getIUIElementType()==ExclusiveGateway.class){
		
			return this.createExclusiveGateway(null);
		
		}else if (bpmndragproxydata.getIUIElementType()==ParallelGateway.class){
			
			return this.createParallelGateway(null);
			
		}else if (bpmndragproxydata.getIUIElementType()==EventBasedGateway.class){
			
			return this.createEventBasedGateway(null);
			
		}
		
		return null;
	}
	
	//EXCLUSIVE GATEWAY
	private Gateway createExclusiveGateway(ExclusiveGatewayBean exclusiveGatewayBean) {
		
		String id = DOM.createUniqueId();
		
		if (exclusiveGatewayBean!=null) id=exclusiveGatewayBean.getId();
		
		ExclusiveGateway exclusiveGatewayView = new ExclusiveGateway(definitionPanel, id);
		
		if (exclusiveGatewayBean==null){
			
			exclusiveGatewayView.getDiagramElement().setModelElement(new ExclusiveGatewayBean(id));

		}else{
			
			ExclusiveGatewayEditorModel model = (ExclusiveGatewayEditorModel) exclusiveGatewayView.getEditorModel();
			
			model.setName(exclusiveGatewayBean.getName());
			model.setDocumentation(exclusiveGatewayBean.getDocumentation());
			model.setDefaultSequenceFlow(exclusiveGatewayBean.getDefaultSequenceFlow());
			
			exclusiveGatewayView.getDiagramElement().setModelElement(exclusiveGatewayBean);
			
		}
		
		ExclusiveGatewayFormTemplate t = new ExclusiveGatewayFormTemplate(exclusiveGatewayView);
		
		return exclusiveGatewayView;
	}
	
	//PARALLEL GATEWAY
	private Gateway createParallelGateway(ParallelGatewayBean parallelGatewayBean){
		
		String id = DOM.createUniqueId();
		
		if (parallelGatewayBean!=null) id=parallelGatewayBean.getId();
		
		ParallelGateway parallelGatewayView = new ParallelGateway(definitionPanel, id);
		
		if (parallelGatewayBean==null){
			
			parallelGatewayView.getDiagramElement().setModelElement(new ParallelGatewayBean(id));			
		
		}else{
			
			ParallelGatewayEditorModel model = (ParallelGatewayEditorModel) parallelGatewayView.getEditorModel();
			
			model.setName(model.getName());
			model.setDocumentation(model.getDocumentation());

			parallelGatewayView.getDiagramElement().setModelElement(parallelGatewayBean);
		}

		ParallelGatewayFormTemplate t = new ParallelGatewayFormTemplate(parallelGatewayView);
		
		return parallelGatewayView;
	}
	
	//EVENT BASED GATEWAY
	private Gateway createEventBasedGateway(EventBasedGatewayBean eventBasedGatewayBean){
		
		String id = DOM.createUniqueId();
		
		if (eventBasedGatewayBean!=null) id=eventBasedGatewayBean.getId();
		
		EventBasedGateway eventBasedGatewayView = new EventBasedGateway(definitionPanel, id);
		
		if (eventBasedGatewayBean==null){
		
			eventBasedGatewayView.getDiagramElement().setModelElement(new EventBasedGatewayBean(id));
			
		}else{
			
			EventBasedGatewayEditorModel model = (EventBasedGatewayEditorModel) eventBasedGatewayView.getEditorModel();
			
			model.setName(model.getName());
			model.setDocumentation(model.getDocumentation());
			model.setInstantiate(model.getInstantiate());
			model.setType(model.getType());
			
			eventBasedGatewayView.getDiagramElement().setModelElement(eventBasedGatewayBean);
			
		}


		
		EventBasedGatewayFormTemplate t = new EventBasedGatewayFormTemplate(eventBasedGatewayView);
		
		return eventBasedGatewayView;
	}
	

	public IDiagramElementView getElement(
			Class<? extends IDiagramElementView> elementType) {
		
		return null;
	}

	public IDiagramElementView getElementByDiagramElementModel(
			IDiagramElement diagramElement) {
		
		//Exclusive Gateway
		if (diagramElement.getModelElement() instanceof ExclusiveGatewayBean){
			
			ExclusiveGatewayBean exclusiveGatewayBean = (ExclusiveGatewayBean) diagramElement.getModelElement();
			
			
			return this.createExclusiveGateway(exclusiveGatewayBean);
			
		//Parallel Gateway	
		}else if (diagramElement.getModelElement() instanceof ParallelGatewayBean){
			
			ParallelGatewayBean parallelGatewayBean = (ParallelGatewayBean) diagramElement.getModelElement();
			
			return this.createParallelGateway(parallelGatewayBean);
		
		//Event Based Gateway
		}else if (diagramElement.getModelElement() instanceof EventBasedGatewayBean){
			
			EventBasedGatewayBean eventBasedGatewayBean = (EventBasedGatewayBean) diagramElement.getModelElement(); 
			
			return this.createEventBasedGateway(eventBasedGatewayBean);
		}
		
		
		return null;
	}

	public IUIElement getElement(IHasDragProxy draggableProxyData) {

		return null;
	}

	public IUIElement getElement(Class<? extends IUIElement> elementType) {

		return null;
	}
	
	
}
