/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.bpmndiagram.modeleditor.template;

import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.geasytools.diagrameditor.api.graphic.IDiagramElementView;
import com.ebmwebsourcing.geasytools.geasyui.api.core.IUIElement;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder.EnclosedFieldMappingPolicy;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder.IInstantiationHandler;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder.UIBindingManager;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder.uifield.MultipleChoiceListUIField;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder.uifield.events.DisplayEvent;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder.uifield.events.IUIFieldHandler;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ProcessPanel;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.common.CoreBPMNElement;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.editormodels.ProcessEditorModel;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.common.IParticipantBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.infrastructure.IDefinitionsBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.service.IInterfaceBean;
import com.ebmwebsourcing.petalsbpm.business.domain.di.api.IBPMNShape;
import com.google.gwt.user.client.ui.Widget;

public class ProcessFormTemplate extends CommonFormTemplate{
	
	private ProcessPanel processPanel;
	
	public ProcessFormTemplate(ProcessPanel descriptivePanel) {
		super(descriptivePanel);
	
		this.processPanel = descriptivePanel;
		
	}

	public ProcessFormTemplate(CoreBPMNElement bpmnElement) {
		super(bpmnElement);
		// TODO Auto-generated constructor stub
	}

	@Override
	public List<LabelWidgetPair> getPairs() {
		ArrayList<LabelWidgetPair> result = new ArrayList<LabelWidgetPair>();	
		
		result.addAll(super.getPairs());
			
		Widget interfaces = (Widget) this.getUIField("interfaces");
		
		
		if (interfaces!=null && processPanel.isExecutableProcess()){
			
			if (getExpandedPool()==null) result.add(new LabelWidgetPair("Interfaces", interfaces));
		
		}
		
		
		return result;
	}

	@Override
	protected String getTitle() {
		return "Process";
	}	
	
	@Override
	public void initMappingPolicies() {
		
		final IDefinitionsBean defs  = (IDefinitionsBean) processPanel.getMainModel();

		EnclosedFieldMappingPolicy efmp1 = new EnclosedFieldMappingPolicy(ProcessEditorModel.class, "interfaces", new IInstantiationHandler<MultipleChoiceListUIField<List<IInterfaceBean>,IInterfaceBean>>() {
			@Override
			public MultipleChoiceListUIField<List<IInterfaceBean>, IInterfaceBean> instantiate() {
				

				final MultipleChoiceListUIField<List<IInterfaceBean>,IInterfaceBean> list = new MultipleChoiceListUIField<List<IInterfaceBean>,IInterfaceBean>(defs.getInterfaces()); 
				
				list.addUIFieldHandler(new IUIFieldHandler() {
					
					@Override
					public void onDisplay(DisplayEvent event) {
						
						List<IInterfaceBean> interfaces = defs.getInterfaces(); 
						
						list.setOptions(interfaces);
						
					}
				});
				
				
				return list;
			}
		});
		
		UIBindingManager.getInstance().addClassMappingPolicy(efmp1);
		
		
	}
	
	private IDiagramElementView getExpandedPool(){
		
		
		for(IUIElement el:processPanel.getUIElements().values()){
			
			IDiagramElementView elView = (IDiagramElementView) el;
			
			if ((elView.getDiagramElement().getModelElement() instanceof IParticipantBean)){
				
				if (elView.getDiagramElement() instanceof IBPMNShape){
					
					IBPMNShape shape = (IBPMNShape) elView.getDiagramElement();
					
					if (shape.isExpanded()) return elView;
					
				}
				
			}
			
			
		}
		
		
		return null;
	}
	
}
