/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


package com.ebmwebsourcing.petalsbpm.bpmndiagram.palette;

import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.IUIPanel;
import com.ebmwebsourcing.geasytools.geasyui.impl.palette.Palette;
import com.ebmwebsourcing.geasytools.geasyui.impl.palette.PaletteGroup;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.dragproxy.impl.activities.TaskDragProxy;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.dragproxy.impl.collaboration.LaneDragProxy;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.dragproxy.impl.collaboration.PoolDragProxy;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.dragproxy.impl.connectors.MessageFlowDragProxy;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.dragproxy.impl.connectors.SequenceFlowDragProxy;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.dragproxy.impl.events.EndMessageDragProxy;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.dragproxy.impl.events.EndNoneDragProxy;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.dragproxy.impl.events.StartTopLevelMessageDragProxy;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.dragproxy.impl.events.StartTopLevelNoneDragProxy;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.dragproxy.impl.gateways.ExclusiveGatewayDragProxy;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.dragproxy.impl.gateways.ParallelGatewayDragProxy;

public class CollaborationPalette extends Palette {

    public CollaborationPalette(IUIPanel uipanel) {
        super(uipanel);

        // containers
        PaletteGroup containersGroup = new PaletteGroup("Containers");
        containersGroup.addElement(new PoolDragProxy(uipanel));
        containersGroup.addElement(new LaneDragProxy(uipanel));

        // activities
        PaletteGroup activitiesGroup = new PaletteGroup("Activities");
        activitiesGroup.addElement(new TaskDragProxy(uipanel));

        // events
        PaletteGroup eventsGroup = new PaletteGroup("Events");

        StartTopLevelNoneDragProxy evdp1 = new StartTopLevelNoneDragProxy(uipanel);
        StartTopLevelMessageDragProxy evdp2 = new StartTopLevelMessageDragProxy(uipanel);
        EndNoneDragProxy evdp3 = new EndNoneDragProxy(uipanel);
        EndMessageDragProxy evdp4 = new EndMessageDragProxy(uipanel);

        eventsGroup.addElement(evdp1);
        eventsGroup.addElement(evdp2);
        eventsGroup.addElement(evdp3);
        eventsGroup.addElement(evdp4);

        // Gateways
        PaletteGroup gatewaysGroup = new PaletteGroup("Gateways");

        ExclusiveGatewayDragProxy gwydp1 = new ExclusiveGatewayDragProxy(uipanel);
        ParallelGatewayDragProxy gwydp2 = new ParallelGatewayDragProxy(uipanel);

        gatewaysGroup.addElement(gwydp1);
        gatewaysGroup.addElement(gwydp2);

        // connectors
        PaletteGroup connectorsGroup = new PaletteGroup("Connectors");

        SequenceFlowDragProxy sfDragProxy = new SequenceFlowDragProxy(uipanel);
        MessageFlowDragProxy mfdp = new MessageFlowDragProxy(uipanel);

        connectorsGroup.addElement(sfDragProxy);
        connectorsGroup.addElement(mfdp);

        this.addGroup(containersGroup);
        this.addGroup(activitiesGroup);
        this.addGroup(eventsGroup);
        this.addGroup(gatewaysGroup);
        this.addGroup(connectorsGroup);
    }

}
