/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.bpmndiagram.process.activities;

import com.ebmwebsourcing.geasytools.diagrameditor.api.modeleditor.IEditorModel;
import com.ebmwebsourcing.geasytools.diagrameditor.api.syntax.IDiagramElementSyntaxModelBinder;
import com.ebmwebsourcing.geasytools.diagrameditor.domain.diagramdefinition.interchange.api.IDiagramElement;
import com.ebmwebsourcing.geasytools.diagrameditor.domain.diagramdefinition.interchange.api.IModelElement;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.editormodels.TaskEditorModel;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.Constants.TaskType;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.activity.ReceiveTaskBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.activity.SendTaskBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.activity.ServiceTaskBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.activity.TaskBean;

public class TaskSyntaxModelBinder implements IDiagramElementSyntaxModelBinder{
	
	private Task task;
	public TaskSyntaxModelBinder(Task task) {
		this.task = task;
	}

	public void bindSyntaxModel(IModelElement diagramElementSyntaxModel,
			IEditorModel editorModel, IDiagramElement diagramElement) {
		
		TaskEditorModel taskEditorModel = (TaskEditorModel) editorModel;
		
		
		TaskBean taskBean = (TaskBean) diagramElementSyntaxModel;
		
		//first check that bean type is the right one regarding data
		//provided in editors models task type
		
		if (taskEditorModel.getTaskType()==TaskType.NONE){

			if (diagramElementSyntaxModel instanceof ServiceTaskBean || 
				diagramElementSyntaxModel instanceof SendTaskBean 	 ||
				diagramElementSyntaxModel instanceof ReceiveTaskBean
			){
				
				task.getDiagramElement().setModelElement(new TaskBean(diagramElementSyntaxModel.getId()));
				
			}
			
			commonBind(taskBean, taskEditorModel);
			
		}else if (taskEditorModel.getTaskType()==TaskType.SERVICE_TASK){
			
			//if its already an instance of service task
			if (diagramElementSyntaxModel instanceof ServiceTaskBean){
				
				serviceTaskBind((ServiceTaskBean) diagramElementSyntaxModel, taskEditorModel);
				
			}else{
				
				//otherwise change reference
				ServiceTaskBean serviceTaskBean = new ServiceTaskBean(diagramElementSyntaxModel.getId());
				serviceTaskBean.setProcess(taskBean.getProcess());
				
				task.getDiagramElement().setModelElement(serviceTaskBean);
				serviceTaskBind((ServiceTaskBean) task.getDiagramElement().getModelElement(), taskEditorModel);
			
			}
			
		}else if (taskEditorModel.getTaskType()==TaskType.SEND_TASK){
			
			
			//if its already an instance of service task
			if (diagramElementSyntaxModel instanceof SendTaskBean){
				
				sendTaskBind((SendTaskBean) diagramElementSyntaxModel, taskEditorModel);
				
			}else{
				
				//otherwise change reference
				SendTaskBean sendTaskBean = new SendTaskBean(diagramElementSyntaxModel.getId()); 
				sendTaskBean.setProcess(taskBean.getProcess());
				
				task.getDiagramElement().setModelElement(sendTaskBean);
				
				sendTaskBind((SendTaskBean) task.getDiagramElement().getModelElement(), taskEditorModel);
			
			}			
			
		}else if (taskEditorModel.getTaskType()==TaskType.RECEIVE_TASK){
			
			//if its already an instance of service task
			if (diagramElementSyntaxModel instanceof ReceiveTaskBean){
				
				receiveTaskBind((ReceiveTaskBean) diagramElementSyntaxModel, taskEditorModel);
				
			}else{
				
				//otherwise change reference
				ReceiveTaskBean receiveTaskBean = new ReceiveTaskBean(diagramElementSyntaxModel.getId());
				receiveTaskBean.setProcess(taskBean.getProcess());
				
				task.getDiagramElement().setModelElement(receiveTaskBean);
				receiveTaskBind((ReceiveTaskBean) task.getDiagramElement().getModelElement(), taskEditorModel);
			
			}

			
		}
		

		

		
		
		
	}
	
	public void commonBind(TaskBean taskBean,TaskEditorModel taskEditorModel){
		
		taskBean.setName(taskEditorModel.getName());
		taskBean.setDocumentation(taskEditorModel.getDocumentation());
		taskBean.setDefaultSequenceFlow(taskEditorModel.getDefaultSequenceFlow());

	}
	
	public void serviceTaskBind(ServiceTaskBean serviceTaskBean,TaskEditorModel taskEditorModel){
		this.commonBind(serviceTaskBean, taskEditorModel);
		serviceTaskBean.setOperation(taskEditorModel.getOperation());
	}
	public void sendTaskBind(SendTaskBean sendTaskBean,TaskEditorModel taskEditorModel){
		this.commonBind(sendTaskBean, taskEditorModel);
		sendTaskBean.setOperation(taskEditorModel.getOperation());
		sendTaskBean.setMessage(taskEditorModel.getMessage());
	}
	public void receiveTaskBind(ReceiveTaskBean receiveTaskBean,TaskEditorModel taskEditorModel){
		this.commonBind(receiveTaskBean, taskEditorModel);
		receiveTaskBean.setMessage(taskEditorModel.getMessage());
		receiveTaskBean.setOperation(taskEditorModel.getOperation());
	}
	
	
}
