/**
 * bpmn-plugins - Geasy BPMN Editor Plugins - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.ebmwebsourcing.petalsbpm.client.component.bpmn;

import com.ebmwebsourcing.geasytools.diagrameditor.DiagramController;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.detachable.IDetachableProxy;
import com.ebmwebsourcing.geasytools.webeditor.api.plugin.IProjectPlugin;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.model.builder.ChoreographyBuilder;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.diagram.ProcessPanel;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.choreography.IChoreographyBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.infrastructure.IDefinitionsBean;
import com.ebmwebsourcing.petalsbpm.business.domain.di.api.IBPMNDiagram;
import com.ebmwebsourcing.petalsbpm.business.domain.di.impl.BPMNChoreographyDiagram;
import com.ebmwebsourcing.petalsbpm.client.plugin.bpmn.BPMNProjectInstance;
import com.ebmwebsourcing.webeditor.api.domain.project.IProjectInstance;

public class ChoreographyPanelComponent extends ProcessPanelComponent {

	public ChoreographyPanelComponent(IProjectPlugin<?> p,
			ProcessPanel definitionPanel) {
		super(p, definitionPanel);
		
	}
	
	
	@Override
	protected void initializeDiagramController(IProjectInstance projectInstance) {
		BPMNProjectInstance bpmnprojectInstance = (BPMNProjectInstance) projectInstance;
		this.diagramController = new DiagramController(getDiagramView(),new BPMNChoreographyDiagram(),diagramModelEditorComponent.getEditorView(),bpmnprojectInstance.getDefinitions());
		diagramController.setSyntaxModelBuilder(new ChoreographyBuilder());
	}
	
	@Override
	public IProjectInstance getProjectInstance() {
		
		IDefinitionsBean defs = (IDefinitionsBean) diagramController.getMainModelElement();
		IChoreographyBean choreography = (IChoreographyBean) diagramController.getDiagramSyntaxModel();
		defs.addChoreography(choreography);
		projectInstance.setDefinitions(defs);
		
		projectInstance.setBpmndiagram((IBPMNDiagram) ((IDetachableProxy<?>)diagramController.getDiagramInterchangeModel(true)).getDetachedModel());

		return projectInstance;
	}
	
}
