/**
 * bpmn-plugins - Geasy BPMN Editor Plugins - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.client.plugin.bpmn.descriptive;

import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.geasytools.webeditor.api.core.events.IEditorEventBus;
import com.ebmwebsourcing.geasytools.webeditor.api.plugin.IProjectPlugin;
import com.ebmwebsourcing.geasytools.webeditor.api.project.configuration.view.IEditConfigurationPanel;
import com.ebmwebsourcing.geasytools.webeditor.api.project.configuration.view.INewProjectConfigurationView;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.plugin.Plugin;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.mock.IdGenerator;
import com.ebmwebsourcing.webeditor.impl.domain.user.User;

public abstract class DescriptiveBPMNProjectPlugin extends Plugin implements IProjectPlugin<DescriptiveBPMNProjectInstance> {

    private DescriptiveBPMNProjectType projectType;

    private NewDescriptiveBPMNProjectConfigurationView newBPMNProjectConfigurationView;

    private IEditorEventBus eventBus;
    
    
    
    
    public DescriptiveBPMNProjectPlugin(DescriptiveBPMNProjectType type) {
        this.projectType = type;
        this.newBPMNProjectConfigurationView = new NewDescriptiveBPMNProjectConfigurationView(this);
    
    
    }

    @Override
    public DescriptiveBPMNProjectType getProjectType() {
        return projectType;
    }

    @Override
    public List<IEditConfigurationPanel> getEditConfigurationPanels(DescriptiveBPMNProjectInstance instance) {
    	
    	EditBPMNDefinitionsConfigurationPanel editBPMNDefinitionsConfigurationPanel = new EditBPMNDefinitionsConfigurationPanel(this,instance,false);
        
    	List<IEditConfigurationPanel> configurationPanels = new ArrayList<IEditConfigurationPanel>();
        
        configurationPanels.add(editBPMNDefinitionsConfigurationPanel);	
    	
    	return configurationPanels;
    }
    
    @Override
    public String getName() {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public INewProjectConfigurationView getConfigurationView() {
        return newBPMNProjectConfigurationView;
    }

    @Override
    public void setEventBus(IEditorEventBus eventBus) {
        this.eventBus = eventBus;
    }

    public IEditorEventBus getEventBus() {
        return this.eventBus;
    }
    
    @Override
    public DescriptiveBPMNProjectInstance createNewProjectInstance() {
    	
    	DescriptiveBPMNProjectInstance bpmnProjectInstance = new DescriptiveBPMNProjectInstance(getProjectType());
		bpmnProjectInstance.setId(IdGenerator.createUniqueId());
		
		//TODO: replace by a true request
		User user = new User();
		user.setLogin("user1");
		user.setId("user1ID");

		bpmnProjectInstance.setAuthor(user);
    	
		return bpmnProjectInstance;
    }

}
