/**
 * bpmn-plugins - Geasy BPMN Editor Plugins - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.client.plugin.bpmn.executable;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import com.ebmwebsourcing.geasytools.webeditor.api.core.events.IEditorEventBus;
import com.ebmwebsourcing.geasytools.webeditor.api.plugin.IProjectPlugin;
import com.ebmwebsourcing.geasytools.webeditor.api.project.configuration.view.IEditConfigurationPanel;
import com.ebmwebsourcing.geasytools.webeditor.api.project.configuration.view.INewProjectConfigurationView;
import com.ebmwebsourcing.geasytools.webeditor.api.project.configuration.view.events.IExportProjectConfigurationCompleteEvent;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.plugin.Plugin;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.project.configuration.events.ExportProjectConfigurationCompleteEvent;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.mock.IdGenerator;
import com.ebmwebsourcing.petalsbpm.client.plugin.bpmn.descriptive.EditBPMNDefinitionsConfigurationPanel;
import com.ebmwebsourcing.webeditor.impl.domain.user.User;


public abstract class ExecutableBPMNProjectPlugin extends Plugin implements IProjectPlugin<ExecutableBPMNProjectInstance>{

	private ExecutableBPMNProjectType projectType;
	private NewExecutableBPMNProjectConfigurationView view;
	
//	private static IProjectConfigurationHandler handler;
	private static IEditorEventBus eventBus;
	private static Set<IExportProjectConfigurationCompleteEvent> sentByWindow = new HashSet<IExportProjectConfigurationCompleteEvent>();
	
	
	public ExecutableBPMNProjectPlugin(ExecutableBPMNProjectType type){
		projectType = type;
		view = new NewExecutableBPMNProjectConfigurationView(this);
	}
	
	
	@Override
	public INewProjectConfigurationView getConfigurationView() {
		return view;
	}

	@Override
	public ExecutableBPMNProjectType getProjectType() {
		return projectType;
	}

	@Override
	public String getName() {
		// TODO Auto-generated method stub
		return null;
	}

	public static void addEvent(ExportProjectConfigurationCompleteEvent e){
		sentByWindow.add(e);
		eventBus.fireEvent(e);
	}


	@Override
	public void setEventBus(IEditorEventBus eventBus) {
		ExecutableBPMNProjectPlugin.eventBus = eventBus;
//		ExecutableBPMNProjectPlugin.eventBus.addProjectConfigurationHandler(getHandler());
	}
	
	
	public IEditorEventBus getEventBus(){
		return eventBus;
	}
	
	@Override
	public List<IEditConfigurationPanel> getEditConfigurationPanels(ExecutableBPMNProjectInstance instance) {
    	EditBPMNDefinitionsConfigurationPanel editBPMNDefinitionsConfigurationPanel = new EditBPMNDefinitionsConfigurationPanel(this,instance,true);
        
    	List<IEditConfigurationPanel> configurationPanels = new ArrayList<IEditConfigurationPanel>();
        
        configurationPanels.add(editBPMNDefinitionsConfigurationPanel);	
    	
    	return configurationPanels;
	}
	
	@Override
	public ExecutableBPMNProjectInstance createNewProjectInstance() {
		
		ExecutableBPMNProjectInstance bpmnProjectInstance  = new ExecutableBPMNProjectInstance(getProjectType());
		bpmnProjectInstance.setId(IdGenerator.createUniqueId());
		//TODO: replace by a true request
		User user = new User();
		user.setLogin("user1");
		user.setId("user1ID");

		bpmnProjectInstance.setAuthor(user);

		
		return bpmnProjectInstance;
	}
	
//	public static IProjectConfigurationHandler getHandler() {
//		if(handler==null){
//			handler = new IProjectConfigurationHandler() {
//				@Override
//				public void onConfigurationComplete(IProjectConfigurationCompleteEvent event) {
//					if(event instanceof IExportProjectConfigurationCompleteEvent){
//						IExportProjectConfigurationCompleteEvent eepc = (IExportProjectConfigurationCompleteEvent) event;
//						
//						if(sentByWindow.contains(eepc)){
//							sentByWindow.remove(eepc);
//						}
//						else{
//							if(eepc.getProjectInstance() instanceof ExecutableBPMNProjectInstance 
//									&& eepc.getFormat().equals(BPMNExportFormat.BPEL)){
//								eepc.cancel();
//								
//								ExecutableBPMNProjectInstance pi = (ExecutableBPMNProjectInstance) eepc.getProjectInstance();
//			
//								try{
//									new BPELTransformationValidator().validate((DefinitionsBean)pi.getDefinitions());
//								}
//								catch(BPELTransformationValidationException e){
//									MessageBox.alert("Validation Failed",e.getAllErrorsMessage());
//									return;
//								}
//								catch(Exception e){
//									MessageBox.alert("Validation Error", "An error occured during the validation. "+e.getMessage());
//									return;
//								}
//								
//								List<FileRepositoryDescription> l = new ArrayList<FileRepositoryDescription>();
//								l.add(new PetalsMasterDescription());
//								new MappingWindow((DefinitionsBean)pi.getDefinitions(), IdGenerator.createUniqueId(), new BPELExportConfigurationPageChangeListener(pi.getBpmndiagram(),(ExecutableBPMNProjectType) pi.getProjectType()), l).show();
//							}
//						}
//						
//					}
//				}
//			};
//		}
//		return handler;
//	}

}
