/**
 * bpmn-plugins - Geasy BPMN Editor Plugins - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.client.plugin.bpmn.executable;

import java.util.ArrayList;

import com.ebmwebsourcing.geasytools.gwtextwidgets.wizard.Wizard;
import com.ebmwebsourcing.geasytools.gwtextwidgets.wizard.WizardFrame;
import com.ebmwebsourcing.geasytools.webeditor.api.plugin.IProjectPlugin;
import com.ebmwebsourcing.geasytools.webeditor.api.project.configuration.view.INewProjectConfigurationView;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.project.configuration.events.NewProjectConfigurationCompleteEvent;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.project.configuration.view.ProjectConfigurationView;
import com.ebmwebsourcing.geasytools.widgets.ext.api.wizard.IFrame;
import com.ebmwebsourcing.geasytools.widgets.ext.api.wizard.event.IBackEvent;
import com.ebmwebsourcing.geasytools.widgets.ext.api.wizard.event.ICancelEvent;
import com.ebmwebsourcing.geasytools.widgets.ext.api.wizard.event.IFinishEvent;
import com.ebmwebsourcing.geasytools.widgets.ext.api.wizard.event.ILoadEvent;
import com.ebmwebsourcing.geasytools.widgets.ext.api.wizard.event.INextEvent;
import com.ebmwebsourcing.geasytools.widgets.ext.api.wizard.event.IWizardHandler;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.mock.IdGenerator;
import com.ebmwebsourcing.webeditor.impl.domain.user.User;
import com.google.gwt.user.client.ui.Widget;
import com.gwtext.client.widgets.HTMLPanel;
import com.gwtext.client.widgets.Panel;
import com.gwtext.client.widgets.Window;
import com.gwtext.client.widgets.form.Field;
import com.gwtext.client.widgets.form.FormPanel;
import com.gwtext.client.widgets.form.TextField;
import com.gwtext.client.widgets.form.event.TextFieldListenerAdapter;

public class NewExecutableBPMNProjectConfigurationView extends ProjectConfigurationView implements INewProjectConfigurationView{
	
	private Wizard wizard;
	private Window window;
	
	
	private ExecutableBPMNProjectInstance bpmnProjectInstance;
	private ExecutableBPMNProjectPlugin plugin;
	private TextField projectName;
	
	
	public NewExecutableBPMNProjectConfigurationView(ExecutableBPMNProjectPlugin pl) {
		this.plugin = pl;
		
		this.bpmnProjectInstance  = new ExecutableBPMNProjectInstance(plugin.getProjectType());
		this.bpmnProjectInstance.setId(IdGenerator.createUniqueId());
		//TODO: replace by a true request
		User user = new User();
		user.setLogin("user1");
		user.setId("user1ID");

		this.bpmnProjectInstance.setAuthor(user);
		
		
		this.window = new Window("New "+ getProjectPlugin().getProjectType().getName() +" Project");	
		this.window.setResizable(false);
		this.window.setCloseAction(Window.HIDE);
		this.wizard = new Wizard(500,200);
//		this.wizard.setVisible(false);
		ArrayList<IFrame> frames = new ArrayList<IFrame>();
		frames.add(getFrame1());
		
		this.wizard.setFrames(frames);
		
		this.window.add(wizard);
		
		
		this.wizard.addHandler(new IWizardHandler() {
			
			@Override
			public void onNext(INextEvent event) {
				// TODO Auto-generated method stub
				
			}
			
			@Override
			public void onLoad(ILoadEvent event) {
				// TODO Auto-generated method stub
				
			}
			
			@Override
			public void onFinish(IFinishEvent event) {
				plugin.getEventBus().fireEvent(new NewProjectConfigurationCompleteEvent(bpmnProjectInstance));
				window.hide();
			}
			
			@Override
			public void onCancel(ICancelEvent event) {
				window.hide();
				
			}
			
			@Override
			public void onBack(IBackEvent event) {
				// TODO Auto-generated method stub
				
			}
		});
		
	}


	@Override
	public void close() {
		window.doLayout();
		window.hide();
	}



	@Override
	public void open() {
		projectName.setValue("");
		window.show();
		
	}

	@Override
	public void refresh() {
		// TODO Auto-generated method stub
		
	}




	private WizardFrame getFrame1(){
		
		WizardFrame wf1 = new WizardFrame(wizard);
		
		Panel headerPanel  = new HTMLPanel("<b>New "+getProjectPlugin().getProjectType().getName()+" Project</b> <br> <span>Configure project</span>");
		//headerPanel.setBorder(false);
		headerPanel.setHeight(50);
		
		FormPanel formPanel = new FormPanel();
		
		formPanel.setBorder(false);

		formPanel.setLabelWidth(75);  
	

		  
		
		this.projectName = new TextField("Project name", "projectName",230);
		projectName.addListener(new TextFieldListenerAdapter(){
			@Override
			public void onChange(Field field, Object newVal, Object oldVal) {
				bpmnProjectInstance.setName((String) newVal);
			}
		});
		
		
		projectName.setAllowBlank(false);
		
		formPanel.add(projectName);
		
		
		wf1.add(headerPanel);
		wf1.add(formPanel);
		
		//wf1.setBorder(false);
		
		return wf1;
	}


	@Override
	public IProjectPlugin<?> getProjectPlugin() {
		return plugin;
	}


	@Override
	public Widget asWidget() {
		// TODO Auto-generated method stub
		return null;
	}


	@Override
	public void startProcessing() {
		// TODO Auto-generated method stub
		
	}


	@Override
	public void stopProcessing() {
		// TODO Auto-generated method stub
		
	}

}
