/**
 * bpmn-plugins - Geasy BPMN Editor Plugins - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.client.component.bpmn;

import com.ebmwebsourcing.geasytools.diagrameditor.impl.modeleditor.EditorView;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.component.Component;
import com.gwtext.client.core.Ext;
import com.gwtext.client.widgets.Panel;

public class DiagramModelEditorComponent extends Component{
	
	private EditorView editorView;
	private Panel panel;
	
	public DiagramModelEditorComponent() {
		
		this.panel		= new Panel();
		this.editorView = new EditorView();
		this.panel.setMargins(0, 0, 0, 10);
		
		this.panel.add(editorView);
		

		
		

		initWidget(panel);
		
	}
	
	@Override
	public void hide() {
		Ext.getCmp(panel.getId()).hide();
		super.hide();
	}
	
	@Override
	public void show() {
		Ext.getCmp(panel.getId()).show();
		super.show();
	}
	
	@Override
	public void setTitle(String title) {
		this.panel.setTitle(title);
	}

	

	
	@Override
	public String getId() {
		return this.getElement().getId();
	}
	
	public EditorView getEditorView() {
		return editorView;
	}
}
