/**
 * bpmn-plugins - Geasy BPMN Editor Plugins - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.client.component.bpmn;

import com.ebmwebsourcing.geasytools.geasyui.impl.palette.Palette;
import com.ebmwebsourcing.geasytools.webeditor.api.components.IComponent;
import com.ebmwebsourcing.geasytools.webeditor.api.components.IQualifiedName;
import com.ebmwebsourcing.geasytools.webeditor.api.components.events.IComponentHandler;
import com.ebmwebsourcing.geasytools.webeditor.api.layout.IPlaceHolder;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.layout.events.ComponentHideEvent;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.layout.events.ComponentShownEvent;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.user.client.ui.Composite;
import com.gwtext.client.core.Ext;
import com.gwtext.client.widgets.Panel;

public class PaletteComponent extends Composite implements IComponent{
	
	//private Palette palette;
	private IPlaceHolder placeHolder;
	private Panel panel;
	
	public PaletteComponent(Palette palette) {
		//this.palette  = palette;
		
		this.panel = new Panel();
		
		panel.setHeader(false);
		panel.setAutoScroll(true);
		panel.add(palette);

		initWidget(panel);
	}

	@Override
	public String getId() {
		return this.getElement().getId();
	}

	@Override
	public IPlaceHolder getPlaceHolder() {
		return placeHolder;
	}

	@Override
	public void setTitle(String title) {
		panel.setTitle(title);
	}
	
	@Override
	public IQualifiedName getQualifiedName() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public void hide() {
		Ext.getCmp(panel.getId()).hide();
		this.getPlaceHolder().fireEvent(new ComponentHideEvent(this));
	}

	@Override
	public boolean isVisible() {
		return panel.isVisible();
	}



	@Override
	public void setPlaceHolder(IPlaceHolder placeHolder) {
		this.placeHolder = placeHolder;
	}

	@Override
	public void show() {
		Ext.getCmp(panel.getId()).show();
		this.getPlaceHolder().fireEvent(new ComponentShownEvent(this));
	}

	@Override
	public void fireEvent(GwtEvent<?> event) {
		// TODO Auto-generated method stub
		
	}



	@Override
	public void addHandler(IComponentHandler handler) {
		// TODO Auto-generated method stub
		
	}

}
