/**
 * bpmn-plugins - Geasy BPMN Editor Plugins - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.client.plugin.bpmn.executable;

import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.geasywebeditor.client.file.repository.FileRepositoryDescription;
import com.ebmwebsourcing.petalsbpm.client.plugin.bpmn.BPMNMetaDataFormat;
import com.ebmwebsourcing.petalsbpm.governance.client.master.PetalsMasterDescription;
import com.ebmwebsourcing.petalsbpm.governance.client.ui.FileRepositoryInquiryPanel;
import com.ebmwebsourcing.webeditor.api.domain.project.IProjectInstance;
import com.ebmwebsourcing.webeditor.api.domain.project.IProjectInstanceMetaData;
import com.gwtext.client.widgets.Window;
import com.gwtext.client.widgets.layout.FitLayout;

public class PetalsMasterInquiryWindow extends Window {

    private FileRepositoryInquiryPanel panel;
    
    public PetalsMasterInquiryWindow(IProjectInstance instance) {
        super("Import a WSDL via Petals Master", 500, 250);
        List<FileRepositoryDescription> repoDescs = new ArrayList<FileRepositoryDescription>();
        repoDescs.add(new PetalsMasterDescription());
        panel = new FileRepositoryInquiryPanel(instance, BPMNMetaDataFormat.WSDL1_1, repoDescs);
        panel.start();
        
        this.setLayout(new FitLayout());
        this.add(panel.asWidget());
    }
    
    public List<IProjectInstanceMetaData> getProjectMetadata() {
        return panel.getProjectMetadata();
    }
}
