/**
 * bpmn-plugins - Geasy BPMN Editor Plugins - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.server.plugin.bpmn;

import java.io.File;

public class BPMNFileHelper {
    
    public static final String UnzipDirectoryName = "zip";

    public static File getBPMNFileInFolder(File dir) {
        assert dir.isDirectory();
        File[] files = dir.listFiles();
        if(files!=null && files.length>0) {
            return getBPMNFileInList(files);
        }
        return null;
    }
    
    public static File getBPMNFileInList(File[] files) {
        assert files!=null;
        if(files.length==1) {
            return files[0];
        }
        for(File f : files){
            if(f.getName().startsWith("BPMN_") && f.getName().endsWith(".xml")
                    || f.getName().endsWith(".bpmn")){
                return f;
            }
        }
        return null;
    }
    
    public static  File getOrCreateUnzipDirectory(File f){
        File unzipDir = new File(f.getParent()+File.separator+BPMNFileHelper.UnzipDirectoryName);
        
        if(!unzipDir.exists()){
            unzipDir.mkdir();
        }
        
        return unzipDir;
    }
    
}
