/**
 * bpmn-plugins - Geasy BPMN Editor Plugins - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.server.plugin.bpmn.descriptive.collaboration;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.petalsbpm.client.plugin.bpmn.descriptive.DescriptiveBPMNProjectInstance;
import com.ebmwebsourcing.petalsbpm.client.plugin.bpmn.descriptive.collaboration.DescriptiveBPMNCollaborationProjectType;
import com.ebmwebsourcing.petalsbpm.server.plugin.bpmn.descriptive.DescriptiveBPMNFileReader;
import com.ebmwebsourcing.webeditor.api.domain.project.IProjectInstance;
import com.ebmwebsourcing.webeditor.api.domain.project.IProjectInstanceFormat;
import com.ebmwebsourcing.webeditor.impl.domain.exception.ServiceException;
import com.ebmwebsourcing.webeditor.shared.server.api.service.project.IProjectInstanceLoader;

public class DescriptiveBPMNCollaborationProjectInstanceLoader  implements IProjectInstanceLoader{

    @Override
    public List<IProjectInstance> getProjectInstances(List<File> projectFiles, IProjectInstanceFormat projectFilesFormat) throws ServiceException{
        try{
            DescriptiveBPMNFileReader reader = new DescriptiveBPMNFileReader();
            ArrayList<IProjectInstance> instances = new ArrayList<IProjectInstance>();
            for(File file : projectFiles){
                DescriptiveBPMNProjectInstance result = new DescriptiveBPMNProjectInstance(new DescriptiveBPMNCollaborationProjectType());
                reader.readFile(file,projectFilesFormat,result);
//                result.setDefinitions(reader.getDefinitions());
//                result.setBpmndiagram(reader.getDiagram());
//                result.setName(reader.getDefinitions().getName());
                instances.add(result);
            }
            return instances;
        }
        catch(Exception e){
            e.printStackTrace();
            throw new ServiceException(e.getMessage());
        }
    }

	@Override
	public List<IProjectInstance> getProjectInstances(
			List<IProjectInstance> instances) throws ServiceException {
		// TODO Auto-generated method stub
		return null;
	}

}
