/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.petalsbpm.xpdl;

import com.ebmwebsourcing.easybox.api.XmlContextFactory;
import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybox.api.XmlObjectWriter;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Definitions;
import com.ebmwebsourcing.easybpmn.bpmn20diagram.api.element.BPMNDiagram;
import com.ebmwebsourcing.easybpmn.bpmn20diagram.api.element.BPMNEdge;
import com.ebmwebsourcing.easybpmn.bpmn20diagram.api.element.BPMNLabel;
import com.ebmwebsourcing.easybpmn.bpmn20diagram.api.element.BPMNLabelStyle;
import com.ebmwebsourcing.easybpmn.bpmn20diagram.api.element.BPMNPlane;
import com.ebmwebsourcing.easybpmn.bpmn20diagram.api.element.BPMNShape;
import com.ebmwebsourcing.easybpmn.bpmn20diagram.api.element.Bounds;
import com.ebmwebsourcing.easybpmn.bpmn20diagram.api.element.Font;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.collaboration.ICollaborationBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.infrastructure.DefinitionsBean;
import com.ebmwebsourcing.petalsbpm.business.domain.di.api.IBPMNDiagram;
import com.ebmwebsourcing.petalsbpm.business.domain.di.impl.mock.BPMNDIMockDB;
import com.ebmwebsourcing.petalsbpm.server.service.bpmn2.clientToServer.ClientToServer;
import com.ebmwebsourcing.petalsbpm.server.service.bpmn2.serverToClient.ServerToClient;
import com.ebmwebsourcing.petalsbpm.server.service.bpmndi.clientToServer.BPMNDiagramGenerator;
import com.ebmwebsourcing.petalsbpm.utils.server.FileHelper;
import com.ebmwebsourcing.petalsbpm.xpdl.XPDLAdapter;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilderFactory;
import junit.framework.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class BPMNDItoXPDLtoBPMNDITest {
    private String path;
    private String resultPath;

    @Before
    public void setUp() throws Exception {
        this.path = BPMNDItoXPDLtoBPMNDITest.class.getResource("BPMNDItoXPDLtoBPMNDITest.class").toString().replace("BPMNDItoXPDLtoBPMNDITest.class", "").replace("file:", "");
        this.path = this.path + "testDI" + File.separator;
        this.resultPath = this.path + File.separator + "result" + File.separator;
        File folder = new File(this.resultPath);
        if (!folder.exists()) {
            folder.mkdirs();
        }
    }

    @Test
    public void testMockDBDI1() throws Exception {
        this.test((IBPMNDiagram)BPMNDIMockDB.getDI1(), BPMNDIMockDB.getDefsDI1());
    }

    @Test
    public void testMockDBDI2() throws Exception {
        this.test((IBPMNDiagram)BPMNDIMockDB.getDI2(), BPMNDIMockDB.getDefsDI2());
    }

    @Test
    public void testMockDBDI3() throws Exception {
        this.test((IBPMNDiagram)BPMNDIMockDB.getDI3(), BPMNDIMockDB.getDefsDI3());
    }

    @Test
    public void testMockDBPrivateProcessDI1() throws Exception {
        this.test((IBPMNDiagram)BPMNDIMockDB.getPrivateProcessDI1(), BPMNDIMockDB.getPrivateProcessDefsDI1());
    }

    public void test(IBPMNDiagram diagramBean, DefinitionsBean defsBean) throws Exception {
        BPMNShape other;
        ArrayList<BPMNShape> others;
        String ref1;
        String defsId = defsBean.getId();
        Definitions defs = ClientToServer.adapt((DefinitionsBean)defsBean);
        String bpmnFile = this.path + defsId + ".bpmn";
        BPMNDiagram diagram = BPMNDiagramGenerator.generateBPMNDiagram((IBPMNDiagram)diagramBean);
        defs.addBPMNDiagram(diagram);
        XmlObjectWriter xmlWriter = new XmlContextFactory().newContext().createWriter();
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        xmlWriter.writeDocument((XmlObject)defs, (Node)doc);
        FileHelper.writeFile((String)bpmnFile, (String)XMLPrettyPrinter.prettyPrint((Document)doc));
        XPDLAdapter adapter = new XPDLAdapter();
        File xpdlFile = adapter.getXPDL2FromBPMN2(bpmnFile);
        System.out.println("XPDL file : " + xpdlFile);
        Assert.assertNotNull((Object)xpdlFile);
        adapter.getBPMN2FromXPDL(xpdlFile.toString(), this.resultPath);
        File BPMNFile = new File(this.resultPath + defsId + ".bpmn");
        URL url = BPMNFile.toURI().toURL();
        System.out.println("URL of BPMN file:" + url);
        System.out.println();
        defs = (Definitions)defs.getXmlContext().createReader().readDocument(url, Definitions.class);
        defs.getXmlContext().createValidator().failFastValidate((XmlObject)defs);
        Assert.assertTrue((boolean)defs.hasBPMNDiagram());
        BPMNDiagram diagram2 = defs.getBPMNDiagram()[0];
        Assert.assertNotNull((Object)diagram2);
        Assert.assertEquals((String)diagram.getId(), (String)diagram2.getId());
        Assert.assertEquals((String)diagram.getName(), (String)diagram2.getName());
        Assert.assertEquals((Object)diagram.getResolution(), (Object)diagram2.getResolution());
        this.compareLabelStyles(diagram.getBPMNLabelStyle(), diagram2.getBPMNLabelStyle());
        BPMNPlane plane = diagram.getBPMNPlane();
        BPMNPlane plane2 = diagram2.getBPMNPlane();
        Assert.assertNotNull((Object)plane2);
        Assert.assertEquals((Object)plane.getBpmnElement(), (Object)plane.getBpmnElement());
        Assert.assertNotNull((Object)plane.getDiagramElement());
        Assert.assertNotNull((Object)plane2.getDiagramElement());
        Assert.assertEquals((int)plane.getDiagramElement().length, (int)plane2.getDiagramElement().length);
        Assert.assertNotNull((Object)plane.getBPMNShapes());
        Assert.assertNotNull((Object)plane2.getBPMNShapes());
        Assert.assertEquals((int)plane.getBPMNShapes().length, (int)plane2.getBPMNShapes().length);
        Assert.assertNotNull((Object)plane.getBPMNEdges());
        Assert.assertNotNull((Object)plane2.getBPMNEdges());
        Assert.assertEquals((int)plane.getBPMNEdges().length, (int)plane2.getBPMNEdges().length);
        for (BPMNShape bPMNShape : plane.getBPMNShapes()) {
            Assert.assertNotNull((Object)bPMNShape.getBpmnElement());
            ref1 = bPMNShape.getBpmnElement().getLocalPart();
            others = new ArrayList<BPMNShape>();
            for (BPMNShape bPMNShape2 : plane2.getBPMNShapes()) {
                if (!ref1.equals(bPMNShape2.getBpmnElement().getLocalPart())) continue;
                others.add(bPMNShape2);
            }
            Assert.assertEquals((int)1, (int)others.size());
            other = (BPMNShape)others.get(0);
            Assert.assertNotNull((Object)other);
            this.compareBounds(bPMNShape.getBounds(), other.getBounds());
            this.compareLabels(bPMNShape.getBPMNLabel(), other.getBPMNLabel());
        }
        for (BPMNShape bPMNShape : plane.getBPMNEdges()) {
            Assert.assertNotNull((Object)bPMNShape.getBpmnElement());
            ref1 = bPMNShape.getBpmnElement().getLocalPart();
            others = new ArrayList();
            for (BPMNShape bPMNShape3 : plane2.getBPMNEdges()) {
                if (!ref1.equals(bPMNShape3.getBpmnElement().getLocalPart())) continue;
                others.add(bPMNShape3);
                break;
            }
            Assert.assertEquals((int)1, (int)others.size());
            other = (BPMNEdge)others.get(0);
            Assert.assertNotNull((Object)other);
            this.compareLabels(bPMNShape.getBPMNLabel(), other.getBPMNLabel());
            Assert.assertNotNull((Object)bPMNShape.getWaypoint());
            Assert.assertTrue((bPMNShape.getWaypoint().length >= 2 ? 1 : 0) != 0);
            Assert.assertNotNull((Object)other.getWaypoint());
            Assert.assertTrue((other.getWaypoint().length >= 2 ? 1 : 0) != 0);
            Assert.assertEquals((int)bPMNShape.getWaypoint().length, (int)other.getWaypoint().length);
        }
        DefinitionsBean model = ServerToClient.adapt((Definitions)defs);
        Assert.assertNotNull((Object)model);
        Assert.assertEquals((String)defsBean.getId(), (String)model.getId());
        Assert.assertEquals((String)defsBean.getTargetNamespace(), (String)model.getTargetNamespace());
        if (defsBean.getCollaborations() != null && !defsBean.getCollaborations().isEmpty()) {
            Assert.assertNotNull((Object)model.getCollaborations());
            Assert.assertEquals((int)defsBean.getCollaborations().size(), (int)model.getCollaborations().size());
            Assert.assertNotNull((Object)((ICollaborationBean)defsBean.getCollaborations().get(0)).getParticipants());
            Assert.assertNotNull((Object)((ICollaborationBean)model.getCollaborations().get(0)).getParticipants());
            Assert.assertEquals((int)((ICollaborationBean)defsBean.getCollaborations().get(0)).getParticipants().size(), (int)((ICollaborationBean)model.getCollaborations().get(0)).getParticipants().size());
        }
        Assert.assertNotNull((Object)defsBean.getProcesses());
        Assert.assertNotNull((Object)model.getProcesses());
        Assert.assertEquals((int)defsBean.getProcesses().size(), (int)model.getProcesses().size());
    }

    private void compareLabels(BPMNLabel l1, BPMNLabel l2) {
        if (l1 != null) {
            Assert.assertNotNull((Object)l2);
            Assert.assertEquals((String)l1.getId(), (String)l2.getId());
            Assert.assertEquals((Object)l1.getLabelStyle(), (Object)l2.getLabelStyle());
            this.compareBounds(l1.getBounds(), l2.getBounds());
        } else {
            Assert.assertNull((Object)l2);
        }
    }

    private void compareBounds(Bounds b1, Bounds b2) {
        if (b1 != null) {
            Assert.assertNotNull((Object)b2);
            Assert.assertEquals((Object)b1.getX(), (Object)b2.getX());
            Assert.assertEquals((Object)b1.getY(), (Object)b2.getY());
            Assert.assertEquals((Object)b1.getWidth(), (Object)b2.getWidth());
            Assert.assertEquals((Object)b1.getHeight(), (Object)b2.getHeight());
        } else {
            Assert.assertNull((Object)b2);
        }
    }

    private void compareLabelStyles(BPMNLabelStyle[] bpmnLabelStyle, BPMNLabelStyle[] bpmnLabelStyle2) {
        if (bpmnLabelStyle != null) {
            Assert.assertNotNull((Object)bpmnLabelStyle2);
            Assert.assertEquals((int)bpmnLabelStyle.length, (int)bpmnLabelStyle2.length);
            for (BPMNLabelStyle style1 : bpmnLabelStyle) {
                String id = style1.getId();
                BPMNLabelStyle other = null;
                for (BPMNLabelStyle style2 : bpmnLabelStyle2) {
                    if (!style2.getId().equals(id)) continue;
                    other = style2;
                    break;
                }
                Assert.assertNotNull(other);
                Assert.assertEquals((String)id, (String)other.getId());
                this.compareFont(style1.getFont(), other.getFont());
            }
        } else {
            Assert.assertNull((Object)bpmnLabelStyle2);
        }
    }

    private void compareFont(Font font1, Font font2) {
        if (font1 != null) {
            Assert.assertNotNull((Object)font2);
            Assert.assertEquals((String)font1.getName(), (String)font2.getName());
            Assert.assertEquals((Object)font1.getSize(), (Object)font2.getSize());
            Assert.assertEquals((boolean)font1.isIsBold(), (boolean)font2.isIsBold());
            Assert.assertEquals((boolean)font1.isIsUnderline(), (boolean)font2.isIsUnderline());
            Assert.assertEquals((boolean)font1.isIsItalic(), (boolean)font2.isIsItalic());
            Assert.assertEquals((boolean)font1.isIsStrikeThrough(), (boolean)font2.isIsStrikeThrough());
        } else {
            Assert.assertNull((Object)font2);
        }
    }
}

