/**
 * bpmn-xpdl-transformation - BPMN to XPDL and XPDL to BPMN transformation - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * 
 */
package com.ebmwebsourcing.petalsbpm.xpdl;



import java.io.File;

import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

import org.w3c.dom.Document;

import com.ebmwebsourcing.easybox.api.XmlContextFactory;
import com.ebmwebsourcing.easybox.api.XmlObjectReader;
import com.ebmwebsourcing.easybox.api.XmlObjectWriter;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Definitions;
import com.ebmwebsourcing.easybpmn.bpmn20diagram.api.element.BPMNDiagram;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.petalsbpm.utils.server.FileHelper;
import com.ebmwebsourcing.petalsbpm.utils.server.ZipHelper;
import com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl;

/**
 * @author nrajsiri
 *
 */
public class XPDLAdapter {

	public static String MERGED_FILE_NAME 				= "tmp.xml";

	public static String BPMN2XPDL_XSLT               	= XPDLAdapter.class.getResource("BPMN2XPDL.xml").toString();

	public static String XPDL2BPMN_XSLT               	= XPDLAdapter.class.getResource("XPDL2BPMN.xml").toString();

	public static String XPDL2DI_XSLT               	= XPDLAdapter.class.getResource("XPDL2DI.xml").toString();



	private String xpdlFileAbsolutePath;


	public File getXPDL2FromBPMN2(String bpmn2xmlPath) throws Exception{
	    resolvePaths(bpmn2xmlPath);
	    
		File f2 = new File(bpmn2xmlPath);
		System.out.println("bpmn URI path:" + f2.toURI());

		//2- apply xslt transfo
		//TransformerFactory tFactory = TransformerFactory.newInstance();
		TransformerFactoryImpl tFactory = new TransformerFactoryImpl();
		Transformer transformer = tFactory.newTransformer(new StreamSource(BPMN2XPDL_XSLT));
		transformer.transform(new StreamSource(f2.getAbsolutePath()), new StreamResult(getXpdlFileAbsolutePath()));
		
        File XPDLfile = new File(getXpdlFileAbsolutePath());
        
		return XPDLfile;
	}

	
	private void resolvePaths(String bpmnXmlPath){
		File bpmnFile = new File(bpmnXmlPath);

		String absoluteDirPath = bpmnFile.getParentFile().getAbsolutePath();
		String fileName        = bpmnFile.getName();

		//this.xpdlFileAbsolutePath   = absoluteDirPath + File.separator + fileName.replace(".xml", "")+"_XPDL.xml";
		this.xpdlFileAbsolutePath   = absoluteDirPath + File.separator +fileName.replace(".bpmn", ".xpdl");
	}

	
	public File getBPMN2FromXPDL(String xpdlPath,String savePath) throws Exception{
		//create a tmp Zip folder in savePath
		File tmpZipFolder = new File(savePath+File.separator+"tempZip");

		String XPDL2BPMN_FILE_NAME 		= "BPMN_tmpBPMNZip.xml";
		String XPDL2BPMN_GI_FILE_NAME 	= "tmpBPMNZip_diagram.xml";

		//if it is the first call create the temp directory
		if (tmpZipFolder.exists()==false){
			tmpZipFolder.mkdir();
		}

	    // if it is not delete the files form the previous call
		FileHelper.cleanDirectory(tmpZipFolder);

		//transform to BPMN XML
		//TransformerFactory tFactory = TransformerFactory.newInstance();
		TransformerFactoryImpl tFactory = new TransformerFactoryImpl();
		
		String bpmnFile = tmpZipFolder.getAbsolutePath()+File.separator+XPDL2BPMN_FILE_NAME;
		String diFile = tmpZipFolder.getAbsolutePath()+File.separator+XPDL2BPMN_GI_FILE_NAME;
		
		Transformer transformer = tFactory.newTransformer(new StreamSource(XPDL2BPMN_XSLT));
		transformer.transform(new StreamSource(xpdlPath), new StreamResult(bpmnFile));

		//transform to GI of BPMN
		Transformer transformer2 = tFactory.newTransformer(new StreamSource(XPDL2DI_XSLT));
		transformer2.transform(new StreamSource(xpdlPath), new StreamResult(diFile));

		XmlObjectReader reader = new XmlContextFactory().newContext().createReader();
		Definitions defs = reader.readDocument(new File(bpmnFile).toURI().toURL(), Definitions.class);
		BPMNDiagram diagram = reader.readDocument(new File(diFile).toURI().toURL(), BPMNDiagram.class);
		defs.addBPMNDiagram(diagram);

		XmlObjectWriter writer = defs.getXmlContext().createWriter();
		Document docDefs = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        writer.writeDocument(defs, docDefs);
        String bpmnFileAbsolutePath = FileHelper.getUsablePath(savePath) + File.separator + defs.getId()+".bpmn";
        FileHelper.writeFile(bpmnFileAbsolutePath, XMLPrettyPrinter.prettyPrint(docDefs));
		
		return new File(bpmnFileAbsolutePath);
	}
	
	
//	public File getBPMN2ZipFromXPDL(String xpdlPath,String savePath) throws Exception{
//		try{
//			File tmpZipFolder = getBPMN2FromXPDL(xpdlPath, savePath);
//			//create a zip file from tmp Zip folder
//			File zip = ZipHelper.getInstance().createZipFromFolder(tmpZipFolder.getAbsolutePath(), savePath+File.separator+"tmpBPMNZip.zip");
//
//			//delete temp zip folder
//			//tmpZipFolder.delete();
//			return zip;
//
//		}catch(Exception e){
//			throw new Exception("Couldn't apply XPDL to BPMN transformation:"+ e.getLocalizedMessage());
//		}
//	}
	
	
	public File getBPMN2ZipFromAlternativeXPDL(String xpdlPath,String savePath, String alternativeXPDL2BPMNxslt) throws Exception{
		try{

			TransformerFactory tFactory = TransformerFactory.newInstance();


			//create a tmp Zip folder in savePath
			File tmpZipFolder = new File(savePath+File.separator+"tempZip");

			String XPDL2BPMN_FILE_NAME 		= "BPMN_tmpBPMNZip.xml";
			String XPDL2BPMN_GI_FILE_NAME 	= "tmpBPMNZip_diagram.xml";

			if(tmpZipFolder.exists()==false){
				tmpZipFolder.mkdir();
			}
			
			// if it is not delete the files form the previous call
			File[] files = tmpZipFolder.listFiles();
			if(files!=null){
				for(File f : files){
					f.delete();
				}
			}

			//transform to BPMN XML 
			Transformer transformer = tFactory.newTransformer(new StreamSource(alternativeXPDL2BPMNxslt));
			transformer.transform(new StreamSource(xpdlPath), new StreamResult(tmpZipFolder.getAbsolutePath()+File.separator+XPDL2BPMN_FILE_NAME));

			//transform to GI of BPMN
			Transformer transformer2 = tFactory.newTransformer(new StreamSource(XPDL2DI_XSLT));
			transformer2.transform(new StreamSource(xpdlPath), new StreamResult(tmpZipFolder.getAbsolutePath()+File.separator+XPDL2BPMN_GI_FILE_NAME));


			//create a zip file from tmp Zip folder
			File zip = ZipHelper.getInstance().createZipFromFolder(tmpZipFolder.getAbsolutePath(), savePath+File.separator+"tmpBPMNZip.zip");

			//delete temp zip folder
			tmpZipFolder.delete();


			return zip;

		}catch(Exception e){

			throw new Exception("Couldn't apply XPDL to BPMN transformation:"+ e.getLocalizedMessage());

		}
	}
	


	public String getXpdlFileAbsolutePath() {
		return xpdlFileAbsolutePath;
	}



}
