/**
 * definitions-editor - BPMN Definitions Editor - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.definitionseditor.interfaces;

import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.geasytools.gwtextwidgets.grid.AbstractEditableGrid;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.service.IInterfaceBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.service.IOperationBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.service.InterfaceBean;
import com.ebmwebsourcing.petalsbpm.definitionseditor.Constants.Interface;
import com.google.gwt.user.client.DOM;
import com.gwtext.client.data.FieldDef;
import com.gwtext.client.data.ObjectFieldDef;
import com.gwtext.client.data.Record;
import com.gwtext.client.data.StringFieldDef;
import com.gwtext.client.widgets.Panel;
import com.gwtext.client.widgets.grid.BaseColumnConfig;
import com.gwtext.client.widgets.grid.ColumnConfig;
import com.gwtext.client.widgets.grid.EditorGridPanel;

public class InterfacePanel extends AbstractEditableGrid<IInterfaceBean>{
	
	private Panel wrapper;
	
	public InterfacePanel() {
		super();
		
	}
	
	@Override
	protected void buildGrid() {
		super.buildGrid();
		gridPanel.getView().setForceFit(true);
	}
	
	@Override
	protected void bind(Record record, IInterfaceBean value) {
		value.setName(record.getAsString(Interface.name.toString()));
		value.setOperations((List<IOperationBean>) record.getAsObject(Interface.operations.toString()));
		value.setWsdlImplementationRef(record.getAsString(Interface.implemenrationRef.toString()));
	}
		
	
	@Override
	protected String getAddText() {
		return "Add Interface";
	}

	@Override
	protected IInterfaceBean getNewDefaultRecord() {
		return new InterfaceBean(DOM.createUniqueId());
	}

	@Override
	protected String getRemoveText() {
		return "Remove Interface";
	}

	@Override
	protected Object[] convertDataToObject(IInterfaceBean data) {
		
		Object[] object = new Object[3];
		
		object[0] = data.getName();
		object[1] = data.getOperations();
		object[2] = data.getWsdlImplementationRef();
		
		return object;
	}

	@Override
	protected List<BaseColumnConfig> getColumnsConfig() {
		
		ArrayList<BaseColumnConfig> cc 		= new ArrayList<BaseColumnConfig>();
		
		ColumnConfig nameColumn 	  		= new ColumnConfig(Interface.name.getLabel(), Interface.name.toString());
		
		ColumnConfig operationsColumn 		= new ColumnConfig(Interface.operations.getLabel(), Interface.operations.toString());
		
		ColumnConfig impleRefColumn 		= new ColumnConfig(Interface.implemenrationRef.getLabel(), Interface.implemenrationRef.toString());
		
		cc.add(nameColumn);
		cc.add(operationsColumn);
		cc.add(impleRefColumn);
		
		
		return cc;
	}

	@Override
	protected FieldDef[] getFieldDef() {
		return new FieldDef[]{
				new StringFieldDef(Interface.name.toString()),
				new ObjectFieldDef(Interface.operations.toString()),
				new StringFieldDef(Interface.implemenrationRef.toString()),
		};
	}
	
	@Override
	protected EditorGridPanel getGridPanel() {
		return super.getGridPanel();
	}
	
	public void setWrapper(Panel wrapper) {
		this.wrapper = wrapper;
	}
	
	public Panel getWrapper() {
		return wrapper;
	}

	@Override
	protected boolean isValid(IInterfaceBean data) {
		
		if (data.getName().equals("")==false && data.getName()!=null && data.getOperations().size()>0){
			
			return true;
			
		}
		
		return false;
	}
	
}
