/**
 * definitions-editor - BPMN Definitions Editor - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.definitionseditor.message;

import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.geasytools.gwtextwidgets.grid.AbstractEditableGrid;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.common.IItemDefinitionBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.common.IMessageBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.common.MessageBean;
import com.ebmwebsourcing.petalsbpm.definitionseditor.Constants.Message;
import com.google.gwt.user.client.DOM;
import com.gwtext.client.data.FieldDef;
import com.gwtext.client.data.ObjectFieldDef;
import com.gwtext.client.data.Record;
import com.gwtext.client.data.StringFieldDef;
import com.gwtext.client.widgets.form.TextField;
import com.gwtext.client.widgets.grid.BaseColumnConfig;
import com.gwtext.client.widgets.grid.ColumnConfig;
import com.gwtext.client.widgets.grid.EditorGridPanel;
import com.gwtext.client.widgets.grid.GridEditor;

public class MessagePanel extends AbstractEditableGrid<IMessageBean>{

	private ColumnConfig itemRefColumn;

	public MessagePanel() {
		super();
	}
	
	
	@Override
	protected void buildGrid() {
		super.buildGrid();
		gridPanel.getView().setForceFit(true);
	}
	
	@Override
	protected void bind(Record record, IMessageBean value) {
		
		value.setName(record.getAsString(Message.name.toString()));
		
		IItemDefinitionBean id = (IItemDefinitionBean) record.getAsObject(Message.itemRef.toString());
		
		value.setItemDefinition(id);
	}

	@Override
	protected String getAddText() {
		return "Add Message";
	}

	@Override
	protected IMessageBean getNewDefaultRecord() {
		return new MessageBean(DOM.createUniqueId());
	}

	@Override
	protected String getRemoveText() {
		return "Remove Message";
	}

	@Override
	protected Object[] convertDataToObject(IMessageBean data) {
		
		Object[] object = new Object[2];
		
		object[0] = data.getName();
		object[1] = data.getItemDefinition();
		
		return object;
	}

	@Override
	protected List<BaseColumnConfig> getColumnsConfig() {
		
		ArrayList<BaseColumnConfig> cc 		= new ArrayList<BaseColumnConfig>();
		
		//Name
		ColumnConfig nameColumn = new ColumnConfig(Message.name.getLabel(), Message.name.toString());
		nameColumn.setEditor(new GridEditor(new TextField()));
		
		//ItemRef
		this.itemRefColumn = new ColumnConfig(Message.itemRef.getLabel(), Message.itemRef.toString());
		
		cc.add(nameColumn);
		cc.add(itemRefColumn);
		
		return cc;
	}

	@Override
	protected FieldDef[] getFieldDef() {
		return new FieldDef[]{
				new StringFieldDef(Message.name.toString()),
				new ObjectFieldDef(Message.itemRef.toString()),
		};
	}
	
	public ColumnConfig getItemRefColumn() {
		return itemRefColumn;
	}
	
	@Override
	protected EditorGridPanel getGridPanel() {
		return super.getGridPanel();
	}


	@Override
	protected boolean isValid(IMessageBean data) {
		
		boolean isValid = false;
		
		if (data.getName()!=null && data.getItemDefinition()!=null){
			isValid = true;
		}
		
		return isValid;
	}
	
}
