/**
 * definitions-editor - BPMN Definitions Editor - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.definitionseditor;

public class Constants {
	

	
	//IMPORT
	public enum ImportProperties{
		
		importType("Import Type"),Import("Import"),namespace("NameSpace");
		
		private String label; 
		
		ImportProperties(String label){
			this.label = label;
		}
		
		public String getLabel() {
			return label;
		}
		
		
	}
	
	
	//NAMESPACE DECLARATION
	public enum NamespaceDeclaration{
		
		prefix("Prefix Name"),URI("URI");

		private String label; 
		
		NamespaceDeclaration(String label){
			this.label = label;
		}
		
		public String getLabel() {
			return label;
		}
		
	}
	
	
	
	//ITEM DEFINITION
	public enum ItemDefinition{
		
		itemKind("Item kind"),structureRef("Structure Ref"),importRef("Import")
		,isCollection("Is a collection");
		
		private String label;
		
		private ItemDefinition(String label) {
			this.label = label;
		}
		
		public String getLabel() {
			return label;
		}
		
	}
	
	
	//INTERFACE
	public enum Interface{
		name("Name"),operations("Operations"),implemenrationRef("Implementation Ref");
		
		private String label;
		
		private Interface(String label) {
			this.label = label;
		}
		
		public String getLabel() {
			return label;
		}
	}
	
	//MESSAGE
	public enum Message{
		name("Name"),itemRef("Item Definition");
		
		private String label;
		
		private Message(String label) {
			this.label = label;
		}
		
		public String getLabel() {
			return label;
		}
		
	}
	
	//ERROR
	public enum Error{
		name("Name"),itemRef("Item Definition"),errorCode("Error code");
		
		private String label;
		
		private Error(String label) {
			this.label = label;
		}
		
		public String getLabel() {
			return label;
		}
		
	}
	
	
	//OPERATION
	public enum Operation{
		name("Name"),inMessage("Input Message"),outMessage("Output Message"),
		errorRef("Error"),implementationRef("Implementation");
		
		private String label;
		
		private Operation(String label) {
			this.label = label;
		}
		
		public String getLabel() {
			return label;
		}
		
	}
	
	//SIGNAL
	public enum Signal{
		name("Name"),structureRef("Structure");
		
		private String label;
		
		private Signal(String label) {
			this.label = label;
		}
		
		public String getLabel() {
			return label;
		}
		
	}
	
	
	//CONDITIONAL EVENT DEFINITION
	public enum ConditionalEventDefinition{
		
		id("Id"),expression("expression");
		
		private String label;
		
		private ConditionalEventDefinition(String label) {
			this.label = label;
		}
		
		public String getLabel() {
			return label;
		}
		
		
		
	}
	
	
	//MESSAGE EVENT DEFINITION
	public enum MessageEventDefinition{
		
		id("Id"),messageRef("Message"),operation("Operation");
		
		private String label;
		
		private MessageEventDefinition(String label) {
			this.label = label;
		}
		
		public String getLabel() {
			return label;
		}
		
		
	}
	
	//SIGNAL EVENT DEFINITION
	public enum SignalEventDefinition{
		
		id("Id"),signalRef("Signal");
		
		private String label;
		
		private SignalEventDefinition(String label) {
			this.label = label;
		}
		
		public String getLabel() {
			return label;
		}
		
		
	}
	
	//TIMER EVENT DEFINITION
	public enum TimerEventDefinition{
		
		id("Id"),timeDate("Date"),timeCyle("Cycle"),timeDuration("Duration");
		
		private String label;
		
		private TimerEventDefinition(String label) {
			this.label = label;
		}
		
		public String getLabel() {
			return label;
		}
		
		
	}
}
