/**
 * definitions-editor - BPMN Definitions Editor - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.definitionseditor.common;

import java.util.List;

import com.gwtext.client.data.ArrayReader;
import com.gwtext.client.data.FieldDef;
import com.gwtext.client.data.MemoryProxy;
import com.gwtext.client.data.ObjectFieldDef;
import com.gwtext.client.data.Record;
import com.gwtext.client.data.RecordDef;
import com.gwtext.client.data.Store;
import com.gwtext.client.data.StringFieldDef;
import com.gwtext.client.widgets.Component;
import com.gwtext.client.widgets.form.ComboBox;
import com.gwtext.client.widgets.form.Field;
import com.gwtext.client.widgets.form.event.ComboBoxListenerAdapter;

public abstract class AbstractComboBox<T> extends ComboBox {
	
	private ArrayReader reader;
	
	private Store cbStore;
	
		public AbstractComboBox() {
		
		this.addListener(new ComboBoxListenerAdapter(){
			
			@Override
			public boolean doBeforeShow(Component component) {

				loadStructures();

				return true;
			}
			
			@Override
			public void onFocus(Field field) {
			
				loadStructures();	
				
			}
			

			
			
			
			
		});
	
		initGUI();
	}
	
	private void initGUI(){
		
		RecordDef recordDef 	= new RecordDef(  
                new FieldDef[]{  
                        new StringFieldDef("label"),
                        new ObjectFieldDef("value")
                }  
        );  
		
		MemoryProxy proxy 		= new MemoryProxy(new Object[0][2]);  
		
		this.reader = new ArrayReader(recordDef);  
		this.cbStore = new Store(proxy, reader);  

		this.setDisplayField("label");  
		this.setStore(cbStore); 
		this.setMode(ComboBox.LOCAL);
		this.setEditable(false);
		this.setForceSelection(true);
		this.setAllowBlank(false);
		
	}
	
	
	private void loadStructures(){
		
		this.cbStore.removeAll();
		
		MemoryProxy proxy 	= new MemoryProxy(getDataAsObject());
		
		Store storeTemp 	= new Store(proxy,this.reader);
		storeTemp.reload();
		
		this.cbStore.add(storeTemp.getRecords());
		
		
	}
	
	public Object[][] getDataAsObject(){
		
		Object[][] objs = new Object[getData().size()][2];

		for(int i=0;i<getData().size();i++){
			
			objs[i][0] = getData().get(i).toString();
			objs[i][1] = getData().get(i);
		
		}
		
		
		return objs;
		
		
	}
	
	public abstract List<T> getData();
	
	
}
