/**
 * definitions-editor - BPMN Definitions Editor - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.definitionseditor.eventdefinition.signal;

import java.util.List;

import com.ebmwebsourcing.geasytools.gwtextwidgets.grid.events.AddElementEvent;
import com.ebmwebsourcing.geasytools.gwtextwidgets.grid.events.AfterEditRecordEvent;
import com.ebmwebsourcing.geasytools.gwtextwidgets.grid.events.BeforeEditRecordEvent;
import com.ebmwebsourcing.geasytools.gwtextwidgets.grid.events.CellClickEvent;
import com.ebmwebsourcing.geasytools.gwtextwidgets.grid.events.EditableGridHandler;
import com.ebmwebsourcing.geasytools.gwtextwidgets.grid.events.RemoveElementEvent;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.event.ISignalBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.event.definition.ISignalEventDefinitionBean;
import com.ebmwebsourcing.petalsbpm.definitionseditor.Constants.Message;
import com.ebmwebsourcing.petalsbpm.definitionseditor.Constants.SignalEventDefinition;
import com.ebmwebsourcing.petalsbpm.definitionseditor.common.AbstractController;
import com.ebmwebsourcing.petalsbpm.definitionseditor.definitions.events.AddEventDefinition;
import com.ebmwebsourcing.petalsbpm.definitionseditor.signal.SignalRefComboBox;
import com.gwtext.client.data.Record;
import com.gwtext.client.widgets.form.ComboBox;
import com.gwtext.client.widgets.form.event.ComboBoxListenerAdapter;
import com.gwtext.client.widgets.grid.GridEditor;

public class SignalEventDefinitionController extends AbstractController implements EditableGridHandler{
	
	private SignalEventDefinitionPanel panel;
	
	private List<ISignalBean> signalRefs;
	
	private Record actualRecord;
	
	public SignalEventDefinitionController(SignalEventDefinitionPanel panel,List<ISignalBean> signalRefs) {
		
		this.panel = panel;
		panel.addHandler(this);
		this.signalRefs = signalRefs;
		
		init();
	}
	
	private void init(){
		
		SignalRefComboBox c = new SignalRefComboBox(signalRefs); 
		
		c.addListener(new ComboBoxListenerAdapter(){
			@Override
			public void onSelect(ComboBox comboBox, Record record, int index) {
				
				actualRecord.set(SignalEventDefinition.signalRef.toString(), record.getAsObject("value"));
				
			}
		});
		
		panel.getSignalRefColumn().setEditor(new GridEditor(c));
		
	}
	
	@Override
	public void onAddElement(AddElementEvent<?> event) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onAfterEditRecord(AfterEditRecordEvent<?> event) {
		validate(panel.getSelectedValues().get(0));
	}
	
	private void validate(ISignalEventDefinitionBean b){
		
		if (b.getId()!=null && b.getSignal()!=null){
			fireEvent(new AddEventDefinition(b));
		}
		
	}
	
	@Override
	public void onBeforeEditorRecord(BeforeEditRecordEvent<?> event) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onRemoveElement(RemoveElementEvent<?> event) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onCellClick(CellClickEvent event) {
		this.actualRecord = panel.getGridPanel().getStore().getAt(event.getRowIndex());
	}

}
