/**
 * definitions-editor - BPMN Definitions Editor - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.definitionseditor.eventdefinition.timer;

import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.geasytools.gwtextwidgets.grid.AbstractEditableGrid;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.event.definition.ITimerEventDefinitionBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.event.definition.TimerEventDefinitionBean;
import com.ebmwebsourcing.petalsbpm.definitionseditor.Constants.TimerEventDefinition;
import com.google.gwt.user.client.DOM;
import com.gwtext.client.data.FieldDef;
import com.gwtext.client.data.Record;
import com.gwtext.client.data.StringFieldDef;
import com.gwtext.client.widgets.form.DateField;
import com.gwtext.client.widgets.form.TextField;
import com.gwtext.client.widgets.grid.BaseColumnConfig;
import com.gwtext.client.widgets.grid.ColumnConfig;
import com.gwtext.client.widgets.grid.GridEditor;

public class TimerEventDefinitionPanel extends AbstractEditableGrid<ITimerEventDefinitionBean>{
	
	
	
	public TimerEventDefinitionPanel() {
		super();
	}

	@Override
	protected void bind(Record record, ITimerEventDefinitionBean value) {
		value.setTimeCycle(record.getAsString(TimerEventDefinition.timeCyle.toString()));
		value.setTimeDuration(record.getAsString(TimerEventDefinition.timeDuration.toString()));
		value.setTimeDate(record.getAsString(TimerEventDefinition.timeDate.toString()));
	}

	@Override
	protected void buildGrid() {
		super.buildGrid();
		gridPanel.getView().setForceFit(true);
	}
	
	
	@Override
	protected String getAddText() {
		return "Add Timer Event Definition";
	}

	@Override
	protected ITimerEventDefinitionBean getNewDefaultRecord() {
		return new TimerEventDefinitionBean(DOM.createUniqueId());
	}

	@Override
	protected String getRemoveText() {
		return "Remove Timer Event Definition";
	}

	@Override
	protected Object[] convertDataToObject(ITimerEventDefinitionBean data) {
		
		Object[] object = new Object[4];
		
		object[0] = data.getId();
		object[1] = data.getTimeDate();
		object[2] = data.getTimeCycle();
		object[3] = data.getTimeDuration();
		
		return object;
	}

	@Override
	protected List<BaseColumnConfig> getColumnsConfig() {
		
		ArrayList<BaseColumnConfig> cc 		= new ArrayList<BaseColumnConfig>();
		
		ColumnConfig id = new ColumnConfig(TimerEventDefinition.id.getLabel(), TimerEventDefinition.id.toString());
		
		DateField dateField = new DateField();  
		dateField.setFormat("m/d/Y");  
		
		ColumnConfig timeDate 		= new ColumnConfig(TimerEventDefinition.timeDate.getLabel(), TimerEventDefinition.timeDate.toString());
		ColumnConfig timeCycle 		= new ColumnConfig(TimerEventDefinition.timeCyle.getLabel(), TimerEventDefinition.timeCyle.toString());
		ColumnConfig timeDuration 	= new ColumnConfig(TimerEventDefinition.timeDuration.getLabel(), TimerEventDefinition.timeDuration.toString());
		
		timeDate.setEditor(new GridEditor(new TextField()));
		timeCycle.setEditor(new GridEditor(new TextField()));
		timeDuration.setEditor(new GridEditor(new TextField()));
		
		cc.add(id);
		cc.add(timeDate);
		cc.add(timeCycle);
		cc.add(timeDuration);
		
		return cc;
	}

	@Override
	protected FieldDef[] getFieldDef() {
		return new FieldDef[]{
				new StringFieldDef(TimerEventDefinition.id.toString()),
				new StringFieldDef(TimerEventDefinition.timeDate.toString()),
				new StringFieldDef(TimerEventDefinition.timeCyle.toString()),
				new StringFieldDef(TimerEventDefinition.timeDuration.toString()),
		};
	}

	@Override
	protected boolean isValid(ITimerEventDefinitionBean data) {
		if (data.getId()!=null && (data.getTimeCycle()!=null || data.getTimeDate()!=null || data.getTimeDuration()!=null)){
			return true;
		}
		return false;
	}

}
