/**
 * definitions-editor - BPMN Definitions Editor - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.definitionseditor.imports;

import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.geasytools.gwtextwidgets.grid.events.AddElementEvent;
import com.ebmwebsourcing.geasytools.gwtextwidgets.grid.events.AfterEditRecordEvent;
import com.ebmwebsourcing.geasytools.gwtextwidgets.grid.events.BeforeEditRecordEvent;
import com.ebmwebsourcing.geasytools.gwtextwidgets.grid.events.CellClickEvent;
import com.ebmwebsourcing.geasytools.gwtextwidgets.grid.events.EditableGridHandler;
import com.ebmwebsourcing.geasytools.gwtextwidgets.grid.events.GridHandler;
import com.ebmwebsourcing.geasytools.gwtextwidgets.grid.events.RemoveElementEvent;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.infrastructure.IDefinitionsBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.infrastructure.IImportBean;
import com.ebmwebsourcing.petalsbpm.definitionseditor.Constants.ImportProperties;
import com.ebmwebsourcing.petalsbpm.definitionseditor.common.AbstractController;
import com.ebmwebsourcing.petalsbpm.definitionseditor.definitions.events.AddImportEvent;
import com.ebmwebsourcing.petalsbpm.definitionseditor.imports.events.ImportPanelHandler;
import com.ebmwebsourcing.petalsbpm.definitionseditor.imports.events.SelectAddExternalImportEvent;
import com.ebmwebsourcing.petalsbpm.definitionseditor.imports.events.SelectAvailableImportEvent;
import com.gwtext.client.data.MemoryProxy;
import com.gwtext.client.data.Record;
import com.gwtext.client.data.Store;


/**
 * @TODO: A row can only be edited if no available import was selected, once selected the row is no more editable 
 * @TODO: "Add import" btn should be enabled only if there are available imports remaining 
 * 
 * @author nfleury
 *
 */
public class ImportController extends AbstractController implements GridHandler,EditableGridHandler,ImportPanelHandler{

	private ImportPanel importPanel;
	

	
	private static int  i;
	
	private List<IImportBean> selectedImports;
	
	private Record actualRecord;
	

	
	public ImportController(final ImportPanel importPanel) {
		

		
		importPanel.addHandler(this);
		importPanel.addImportPanelHandler(this);
		
		this.importPanel 		 = importPanel;
		
		this.selectedImports	 = new ArrayList<IImportBean>();
	}

	@Override
	public void onCellClick(CellClickEvent event) {
		
		this.actualRecord = importPanel.getGridPanel().getStore().getAt(event.getRowIndex());
		
		
	}

	@Override
	public void onAddElement(AddElementEvent<?> event) {
	
		reloadImportPanelComboBoxStore();
		
	}
	
	
	private void reloadImportPanelComboBoxStore(){
		
		importPanel.getCbStore().removeAll();
		
		MemoryProxy proxy 	= new MemoryProxy(getAvailableImportData());
		
		Store storeTemp 	= new Store(proxy,importPanel.getReader());
		storeTemp.reload();
		
		importPanel.getCbStore().add(storeTemp.getRecords());
			
		
	}
	
	
	private Object[][] getAvailableImportData() {
		
		List<IImportBean> retainedImports = new ArrayList<IImportBean>();
		retainedImports.addAll(DefinitionsAvailableImport.getInstance().getImports());
		retainedImports.removeAll(this.selectedImports);
		
		
		int s1 = retainedImports.size();

		Object[][] object = new Object[s1][2];
		
		for(int i=0;i<s1;i++){
			
			IImportBean importB = retainedImports.get(i);
				
				String label 		= importB.getNamespace();
				
				object[i][0] = label;
				object[i][1] = importB;
			}
		
		
		
		
		return object;
	}

	@Override
	public void onRemoveElement(RemoveElementEvent<?> event) {
		
		
	}

	
	public void loadImports(IDefinitionsBean def){
		
		
		
	}

	@Override
	public void onAfterEditRecord(AfterEditRecordEvent<?> event) {
		
		
		Record rec 	= (Record) event.getRecord();
		Object o 	= rec.getAsObject("ObjectRef");
		
		System.out.println("Just edited value=>"+event.getNewValue()+" objectRef=>"+o);
		//importPanel.getGridPanel().getView().getRow(0).re;
		//importPanel.getGridPanel().getView().getCell(event.getIndex(), event.getColIndex()).addClassName("x-form-invalid");
	}




	@Override
	public void onSelectAvailableImport(SelectAvailableImportEvent event) {
		
		//add selected import to selected list so that it is not 
		//part of the list of available imports anymore
		
		IImportBean ib = event.getImportBean(); 
		this.selectedImports.add(ib);
		
		
		//change the displayed values
		this.actualRecord.set(ImportProperties.importType.toString(), ib.getImportType());
		this.actualRecord.set(ImportProperties.namespace.toString(), ib.getNamespace());
		

		fireEvent(new AddImportEvent(ib));
	
	}

	@Override
	public void onBeforeEditorRecord(BeforeEditRecordEvent<?> event) {
		
		reloadImportPanelComboBoxStore();
		
		
	}

	@Override
	public void onSelectAddExternalImport(SelectAddExternalImportEvent event) {
		// TODO Auto-generated method stub
		
	}


	
	
}
