/**
 * definitions-editor - BPMN Definitions Editor - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.definitionseditor.interfaces;

import java.util.HashMap;
import java.util.List;

import com.ebmwebsourcing.geasytools.gwtextwidgets.grid.events.AddElementEvent;
import com.ebmwebsourcing.geasytools.gwtextwidgets.grid.events.AfterEditRecordEvent;
import com.ebmwebsourcing.geasytools.gwtextwidgets.grid.events.BeforeEditRecordEvent;
import com.ebmwebsourcing.geasytools.gwtextwidgets.grid.events.CellClickEvent;
import com.ebmwebsourcing.geasytools.gwtextwidgets.grid.events.EditableGridHandler;
import com.ebmwebsourcing.geasytools.gwtextwidgets.grid.events.RemoveElementEvent;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.common.IErrorBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.common.IMessageBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.service.IInterfaceBean;
import com.ebmwebsourcing.petalsbpm.definitionseditor.Constants.Interface;
import com.ebmwebsourcing.petalsbpm.definitionseditor.common.AbstractController;
import com.ebmwebsourcing.petalsbpm.definitionseditor.operation.OperationController;
import com.gwtext.client.core.EventObject;
import com.gwtext.client.data.Record;
import com.gwtext.client.widgets.Button;
import com.gwtext.client.widgets.MessageBox;
import com.gwtext.client.widgets.Panel;
import com.gwtext.client.widgets.Toolbar;
import com.gwtext.client.widgets.ToolbarButton;
import com.gwtext.client.widgets.event.ButtonListenerAdapter;
import com.gwtext.client.widgets.form.Field;
import com.gwtext.client.widgets.form.event.TextFieldListenerAdapter;

public class InterfaceController extends AbstractController implements EditableGridHandler{

	private InterfacePanel interfacePanel;
	private List<IMessageBean> msgs;
	private List<IErrorBean> errors;
	private List<String> wsdlImplementationRefs;
	private List<String> operationRefs;
	
	
	private Record actualRecord;
	
	private HashMap<IInterfaceBean,InterfaceEditPanel> editPanels;
	
	public InterfaceController(InterfacePanel interfacePanel,List<IMessageBean> msgs,List<IErrorBean> errors,List<String> wsdlImplementationRefs,List<String> operationRefs) {
		
		this.interfacePanel = interfacePanel;
		this.editPanels		= new HashMap<IInterfaceBean, InterfaceEditPanel>();
		this.interfacePanel.addHandler(this);
		
		this.msgs 			= msgs;
		this.wsdlImplementationRefs	= wsdlImplementationRefs;
		this.errors 		= errors;
		this.operationRefs  = operationRefs;
		
		init();
	
	}
	
	private void init(){
		
	

		
	}

	@Override
	public void onAddElement(AddElementEvent<?> event) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onAfterEditRecord(AfterEditRecordEvent<?> event) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onBeforeEditorRecord(BeforeEditRecordEvent<?> event) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onRemoveElement(RemoveElementEvent<?> event) {
		// TODO Auto-generated method stub
		
	}
	

	
	
	@Override
	public void onCellClick(CellClickEvent event) {
		this.actualRecord = interfacePanel.getGridPanel().getStore().getAt(event.getRowIndex());
		
		//get the selected interface => their should be only 1
		final IInterfaceBean ib = interfacePanel.getSelectedValues().get(0);

		//set actual list of operations as an object , otherwise record will return a string
		this.actualRecord.set(Interface.operations.toString(), ib.getOperations());
		
		interfacePanel.getGridPanel().hide();
		
		final InterfaceEditPanel iep = editPanels.get(ib);
		
		//If no panel exists for actual interface bean
		//create it
		if (iep==null){
			
			final InterfaceEditPanel newInterfaceEditPanel = new InterfaceEditPanel(ib);
			
			//bind interface name
			newInterfaceEditPanel.getInterfaceNameTxtField().addListener(new TextFieldListenerAdapter(){
				@Override
				public void onChange(Field field, Object newVal, Object oldVal) {
					
					ib.setName((String) newVal);
					
				}
			});
			
			newInterfaceEditPanel.getImplp().add(new WSDLInterfaceImplementationRefComboBox(wsdlImplementationRefs));
			
			OperationController oc = new OperationController(newInterfaceEditPanel.getOperationPanel(), msgs, errors,operationRefs,ib,this);


			//refresh ui
			editInterace(newInterfaceEditPanel, ib);
			
			
			ToolbarButton okBtn = new ToolbarButton("Ok");
			
			okBtn.addListener(new ButtonListenerAdapter(){
				
				@Override
				public void onClick(Button button, EventObject e) {
					
					if (ib.getName()!=null && ib.getName().equals("")==false){
						
						newInterfaceEditPanel.hide();
						interfacePanel.getGridPanel().show();
						String itname = newInterfaceEditPanel.getInterfaceNameTxtField().getValueAsString();
						
						ib.setName(itname);
						interfacePanel.refresh();
						
					}else{
						
						MessageBox.alert("Missing information", "Please, provide at least a name for actual interface");
						
					}
					
				}
				
			});
			
			ToolbarButton cancelBtn = new ToolbarButton("Cancel");
			cancelBtn.addListener(new ButtonListenerAdapter(){
				
				@Override
				public void onClick(Button button, EventObject e) {
					
					
					newInterfaceEditPanel.hide();
					interfacePanel.getGridPanel().show();
					
					String itname = newInterfaceEditPanel.getInterfaceNameTxtField().getValueAsString();
					
					ib.setName(itname);
					
					interfacePanel.refresh();
					
				}
				
			});
			
			
			Toolbar toolBar = new Toolbar();
			
			newInterfaceEditPanel.setBottomToolbar(toolBar);
			newInterfaceEditPanel.getBottomToolbar().addFill();
			newInterfaceEditPanel.getBottomToolbar().addButton(okBtn);
			newInterfaceEditPanel.getBottomToolbar().addButton(cancelBtn);
			
			this.editPanels.put(ib, newInterfaceEditPanel);
			
			Panel parentPanel = interfacePanel.getWrapper();
			
			parentPanel.add(newInterfaceEditPanel);
			parentPanel.doLayout();
			
			

			
			
			
		//otherwise grab it and display
		}else{
			//refresh ui
			editInterace(iep, ib);
			
			iep.show();
			
		}
		

		
		
	}
	
	private void editInterace(InterfaceEditPanel panel,IInterfaceBean interfaceBean){
		
		//load operations
		panel.getOperationPanel().load(interfaceBean.getOperations());
		
		//set interface name
		panel.getInterfaceNameTxtField().setValue(interfaceBean.getName());

	}
	
}
