/**
 * definitions-editor - BPMN Definitions Editor - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.definitionseditor.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.core.client.Scheduler.ScheduledCommand;
import com.google.gwt.user.client.DOM;
import com.gwtext.client.core.Template;
import com.gwtext.client.data.ArrayReader;
import com.gwtext.client.data.FieldDef;
import com.gwtext.client.data.MemoryProxy;
import com.gwtext.client.data.ObjectFieldDef;
import com.gwtext.client.data.RecordDef;
import com.gwtext.client.data.Store;
import com.gwtext.client.data.StringFieldDef;
import com.gwtext.client.widgets.Component;
import com.gwtext.client.widgets.form.ComboBox;
import com.gwtext.client.widgets.form.Field;
import com.gwtext.client.widgets.form.event.ComboBoxListenerAdapter;

public abstract class AbstractMultipleComboBox<T> extends ComboBox{

	private ArrayReader reader;
	
	private Store cbStore;
	
	private HashMap<T,String> valueIdMap;
	private HashMap<String,T> idValueMap;
	
	private List<T> selectedValues;
	
	private List<String> hasClickHandler;
	
	public AbstractMultipleComboBox() {

		this.valueIdMap 		= new HashMap<T, String>();
		this.idValueMap			= new HashMap<String, T>();
		this.hasClickHandler 	= new ArrayList<String>();
		this.selectedValues		= new ArrayList<T>();
		
		final Template template = new Template("<div class=\"\">" +  
		"<input id=\"{id}\" type=\"checkbox\" value=\"{label}\" > {label}");  
		
		this.setTpl(template);
		this.addListener(new ComboBoxListenerAdapter(){
			
			@Override
			public boolean doBeforeShow(Component component) {

				//loadStructures();

				return true;
			}
			
			@Override
			public void onFocus(Field field) {
				
				loadStructures();
				
				//won't work without deferring
				Scheduler.get().scheduleDeferred(new ScheduledCommand() {
					
					@Override
					public void execute() {
						
						addClickHanders();

					}
				});
				
				
			}
			
			
			
			
			
			
		});
	
		initGUI();

	}
	


	

	
	private void initGUI(){
		
		RecordDef recordDef 	= new RecordDef(  
                new FieldDef[]{  
                        new StringFieldDef("label"),
                        new ObjectFieldDef("value"),
                        new StringFieldDef("id")
                }  
        );  
		
		MemoryProxy proxy 		= new MemoryProxy(new Object[0][3]);  
		
		this.reader = new ArrayReader(recordDef);  
		this.cbStore = new Store(proxy, reader);  

		this.setDisplayField("label");  
		this.setStore(cbStore); 
		this.setMode(ComboBox.LOCAL);
		this.setEditable(false);
		this.setForceSelection(true);
		this.setAllowBlank(false);	
		
	}
	
	
	private void loadStructures(){
		
		this.cbStore.removeAll();
		
		MemoryProxy proxy 	= new MemoryProxy(getDataAsObject());
		
		Store storeTemp 	= new Store(proxy,this.reader);
		storeTemp.reload();
		
		this.cbStore.add(storeTemp.getRecords());
		
		checkSelectedValues();

	}
	
	public Object[][] getDataAsObject(){
		
		Object[][] objs = new Object[getData().size()][3];

		for(int i=0;i<getData().size();i++){
			
			String id = DOM.createUniqueId() ;
			
			objs[i][0] = getData().get(i).toString();
			objs[i][1] = getData().get(i);
			objs[i][2] = id;
			
			this.valueIdMap.put(getData().get(i), id);
			this.idValueMap.put(id, getData().get(i));
		
		}
		
		
		return objs;
		
		
	}
	
	public abstract List<T> getData();	
	
	
	public void setSelectedValues(List<T> selectedValues){
		this.selectedValues = selectedValues;
		this.setValue(this.selectedValues.toString());
	}
	
	public void checkSelectedValues(){
		
		for(T v:selectedValues){
			
			checkInput(valueIdMap.get(v));
			
		}
		
	}
	
	public void addClickHanders(){
		
		for(String id:idValueMap.keySet()){
			
			if (hasClickHandler.contains(id)==false){
				addClickHandler(id);
				hasClickHandler.add(id);
			}
			
		}
	}
	
	
	
	public void addSelectedValue(String id){
		
		if (this.selectedValues.contains(idValueMap.get(id))==false) this.selectedValues.add(idValueMap.get(id));
		this.setValue(this.selectedValues.toString());
		
	}
	
	public void removeSelectedValue(String id){
		this.selectedValues.remove(idValueMap.get(id));
		this.setValue(this.selectedValues.toString());
	}
	
	public native void checkInput(String id)/*-{
		
		$wnd.document.getElementById(id).checked = true;
	
	}-*/;
	
	public native void addClickHandler(String id)/*-{
		
		var t = this;
		
		$wnd.document.getElementById(id).onclick = function(){
			
			if ($wnd.document.getElementById(id).checked == true){
				
				t.@com.ebmwebsourcing.petalsbpm.definitionseditor.common.AbstractMultipleComboBox::addSelectedValue(Ljava/lang/String;)(id);
				
			}else{
			
				t.@com.ebmwebsourcing.petalsbpm.definitionseditor.common.AbstractMultipleComboBox::removeSelectedValue(Ljava/lang/String;)(id);
				
			}	
		
		};

	}-*/;
	
}
