/**
 * definitions-editor - BPMN Definitions Editor - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.definitionseditor.definitions;

import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.infrastructure.IDefinitionsBean;
import com.ebmwebsourcing.petalsbpm.definitionseditor.common.AbstractController;
import com.ebmwebsourcing.petalsbpm.definitionseditor.common.events.CommonHandler;
import com.ebmwebsourcing.petalsbpm.definitionseditor.common.events.PropertyUpdateEvent;
import com.gwtext.client.widgets.form.Field;
import com.gwtext.client.widgets.form.event.TextFieldListenerAdapter;

public class DefinitionsPropertiesController extends AbstractController implements CommonHandler{
	
	private DefinitionsPropertiesPanel propertiesPanel;
	private IDefinitionsBean defs;
	
	public DefinitionsPropertiesController(DefinitionsPropertiesPanel panel,IDefinitionsBean defs) {
		
		this.propertiesPanel = panel;
		this.defs 			 = defs;
		
		propertiesPanel.getName().addListener(new TextFieldListenerAdapter(){
			
			@Override
			public void onChange(Field field, Object newVal, Object oldVal) {
				
				propertiesPanel.fireEvent(new PropertyUpdateEvent(DefinitionsPropertiesController.this.defs));
				
			}
			
		});
		
		
		propertiesPanel.getTns().addListener(new TextFieldListenerAdapter(){
			
			@Override
			public void onChange(Field field, Object newVal, Object oldVal) {
				
				propertiesPanel.fireEvent(new PropertyUpdateEvent(DefinitionsPropertiesController.this.defs));
				
			}
			
		});
		
		propertiesPanel.addHandler(this);
		
	}
	
	@Override
	public void onPropertyUpdate(PropertyUpdateEvent event) {
		
		
		defs.setName(propertiesPanel.getName().getValueAsString());
		defs.setTargetNamespace(propertiesPanel.getTns().getValueAsString());
		
	}
	
	
	public void load(IDefinitionsBean definitions){
		this.defs = definitions;
		
		propertiesPanel.getName().setValue(definitions.getName());
		propertiesPanel.getTns().setValue(definitions.getTargetNamespace());
		
	}

}
