/**
 * definitions-editor - BPMN Definitions Editor - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.definitionseditor.namespace;

import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.geasytools.gwtextwidgets.grid.AbstractGrid;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.infrastructure.INamespaceDeclaration;
import com.ebmwebsourcing.petalsbpm.definitionseditor.Constants.NamespaceDeclaration;
import com.gwtext.client.data.FieldDef;
import com.gwtext.client.data.StringFieldDef;
import com.gwtext.client.widgets.grid.BaseColumnConfig;
import com.gwtext.client.widgets.grid.ColumnConfig;

public class NamespacePanel extends AbstractGrid<INamespaceDeclaration> {

    public NamespacePanel() {
        super();

    }

    @Override
    protected void buildGrid() {
        super.buildGrid();
        gridPanel.getView().setForceFit(true);
    }

    @Override
    protected Object[] convertDataToObject(INamespaceDeclaration data) {

        Object[] object = new Object[2];

        object[0] = data.getPrefix();
        object[1] = data.getURI();

        return object;
    }

    @Override
    protected List<BaseColumnConfig> getColumnsConfig() {

        ArrayList<BaseColumnConfig> cc = new ArrayList<BaseColumnConfig>();

        ColumnConfig prefixC = new ColumnConfig(NamespaceDeclaration.prefix.getLabel(),
                NamespaceDeclaration.prefix.toString());

        ColumnConfig uriC = new ColumnConfig(NamespaceDeclaration.URI.getLabel(),
                NamespaceDeclaration.URI.toString());

        cc.add(prefixC);
        cc.add(uriC);

        return cc;
    }

    @Override
    protected FieldDef[] getFieldDef() {
        return new FieldDef[] { new StringFieldDef(NamespaceDeclaration.prefix.toString()),
                new StringFieldDef(NamespaceDeclaration.URI.toString()), };
    }

    @Override
    protected boolean isValid(INamespaceDeclaration data) {

        if (data.getPrefix() != null && data.getURI() != null) {
            return true;
        }

        return false;
    }

}
