/**
 * definitions-editor - BPMN Definitions Editor - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.definitionseditor.operation;

import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.geasytools.gwtextwidgets.grid.AbstractEditableGrid;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.common.IMessageBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.service.IOperationBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.service.OperationBean;
import com.ebmwebsourcing.petalsbpm.definitionseditor.Constants.Operation;
import com.google.gwt.user.client.DOM;
import com.gwtext.client.data.FieldDef;
import com.gwtext.client.data.ObjectFieldDef;
import com.gwtext.client.data.Record;
import com.gwtext.client.data.StringFieldDef;
import com.gwtext.client.widgets.form.TextField;
import com.gwtext.client.widgets.grid.BaseColumnConfig;
import com.gwtext.client.widgets.grid.ColumnConfig;
import com.gwtext.client.widgets.grid.EditorGridPanel;
import com.gwtext.client.widgets.grid.GridEditor;

public class OperationPanel extends AbstractEditableGrid<IOperationBean>{

	
	
	private ColumnConfig inMessageColumn;
	private ColumnConfig outMessageColumn;
	private ColumnConfig errorRefColumn;
	private ColumnConfig implementationRefColumn;

	public OperationPanel() {
		super();
		
	}
	
	@Override
	protected void buildGrid() {
		super.buildGrid();
		
	}
	
	@Override
	protected void bind(Record record, IOperationBean value) {
		
		value.setName(record.getAsString(Operation.name.toString()));
		value.setMessageIn((IMessageBean) record.getAsObject(Operation.inMessage.toString()));
		value.setMessageOut((IMessageBean)record.getAsObject(Operation.outMessage.toString()));
//		value.setErrors(record);
//		value.setWsdlImplementationRef(ref);
		
	}

	@Override
	protected String getAddText() {
		return "Add Operation";
	}

	@Override
	protected IOperationBean getNewDefaultRecord() {
		return new OperationBean(DOM.createUniqueId());
	}

	@Override
	protected String getRemoveText() {
		return "Remove Operation";
	}

	@Override
	protected Object[] convertDataToObject(IOperationBean data) {
		
		Object[] object = new Object[5];
		
		object[0] = data.getName();
		object[1] = data.getMessageIn();
		object[2] = data.getMessageOut();
		object[3] = data.getErrors();
		object[4] = data.getWsdlImplementationRef();
		
		return object;
	}

	@Override
	protected List<BaseColumnConfig> getColumnsConfig() {
		
		ArrayList<BaseColumnConfig> cc 		= new ArrayList<BaseColumnConfig>();
		
		ColumnConfig nameColumn 			= new ColumnConfig(Operation.name.getLabel(), Operation.name.toString());
		nameColumn.setEditor(new GridEditor(new TextField()));
		
		
		this.inMessageColumn 		= new ColumnConfig(Operation.inMessage.getLabel(), Operation.inMessage.toString());
		this.outMessageColumn 		= new ColumnConfig(Operation.outMessage.getLabel(), Operation.outMessage.toString());
		
		this.errorRefColumn 		= new ColumnConfig(Operation.errorRef.getLabel(), Operation.errorRef.toString());
		
		this.implementationRefColumn = new ColumnConfig(Operation.implementationRef.getLabel(), Operation.implementationRef.toString());
		
		cc.add(nameColumn);
		cc.add(inMessageColumn);
		cc.add(outMessageColumn);
		cc.add(errorRefColumn);
		cc.add(implementationRefColumn);
		
		return cc;
	}
	
	public ColumnConfig getInMessageColumn() {
		return inMessageColumn;
	}
	
	public ColumnConfig getOutMessageColumn() {
		return outMessageColumn;
	}
	
	public ColumnConfig getErrorRefColumn() {
		return errorRefColumn;
	}
	
	public ColumnConfig getImplementationRefColumn() {
		return implementationRefColumn;
	}
	
	@Override
	protected FieldDef[] getFieldDef() {
		return new FieldDef[]{
				new StringFieldDef(Operation.name.toString()),
				new ObjectFieldDef(Operation.inMessage.toString()),
				new ObjectFieldDef(Operation.outMessage.toString()),
				new ObjectFieldDef(Operation.errorRef.toString()),
				new StringFieldDef(Operation.implementationRef.toString())
		};
	}

	@Override
	protected boolean isValid(IOperationBean data) {
		
		if (data.getName()!=null && data.getName().equals("")==false && data.getMessageIn()!=null && data.getMessageOut()!=null){
			return true;
		}
		
		return false;
	}
	
	@Override
	protected EditorGridPanel getGridPanel() {
		return super.getGridPanel();
	}
	
}
