/**
 * governance - A Web based designer for BPMN 2.0 standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.governance.server.master;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.xml.namespace.QName;

import org.ow2.dragon.service.deployment.RequestOptionsTO;
import org.ow2.dragon.service.deployment.ServiceManagerService;
import org.ow2.dragon.service.deployment.ServiceManagerServiceImplService;
import org.ow2.dragon.service.deployment.ServiceSearchProperties;
import org.ow2.dragon.service.deployment.TechnicalServiceTO;
import org.ow2.dragon.service.wsdl.WSDLManagerServiceImplService;

import com.ebmwebsourcing.geasywebeditor.client.file.repository.exception.FileRepositoryInquiryException;
import com.ebmwebsourcing.geasywebeditor.client.file.repository.to.SearchFormData;
import com.ebmwebsourcing.geasywebeditor.server.file.repository.FileRepositoryInquiryService;
import com.ebmwebsourcing.petalsbpm.governance.client.master.PetalsMasterSearchCriteria;
import com.ebmwebsourcing.petalsbpm.governance.client.master.PetalsMasterSearchFormData;


public class PetalsMasterInquiryService implements FileRepositoryInquiryService {

    private static final String serviceManagerSuffix = "/ws/ServiceManagerService?wsdl";
    private static final String wsdlManagerSuffix = "/ws/WsdlManagerService?wsdl";


    @Override
    public void testServicesURL(String rootURL) throws FileRepositoryInquiryException{
        try {
            new ServiceManagerServiceImplService(new URL(rootURL+serviceManagerSuffix));
            new WSDLManagerServiceImplService(new URL(rootURL+wsdlManagerSuffix));
        } catch (Exception e) {
            throw new FileRepositoryInquiryException(e.getMessage());
        }
    }



    @Override
    public String getFileContentAsString(String rootURL, String serviceId) throws FileRepositoryInquiryException{
        try{
            WSDLManagerServiceImplService s = new WSDLManagerServiceImplService(new URL(rootURL+wsdlManagerSuffix));

            List<String> wsdls = s.getWSDLManagerServiceImplPort().loadServiceDescsAsString(serviceId);
            if(wsdls==null || wsdls.isEmpty() || wsdls.size()>1){
                throw new Exception("More than one WSDL file were found.");
            }

            return wsdls.get(0);
        } catch (Exception e) {
            throw new FileRepositoryInquiryException(e.getMessage());
        }
    }



    @Override
    public Map<String, String> searchFile(String rootURL, SearchFormData data) throws FileRepositoryInquiryException {
        try{
            //instantiate the service
            ServiceManagerServiceImplService ss = new ServiceManagerServiceImplService(new URL(rootURL+serviceManagerSuffix));
            ServiceManagerService s = ss.getServiceManagerServiceImplPort();

            //prepare the data for the request
            PetalsMasterSearchFormData pdata = (PetalsMasterSearchFormData) data;
            RequestOptionsTO options = new RequestOptionsTO();
            options.setCaseSensitive(false);

            List<ServiceSearchProperties> l = new ArrayList<ServiceSearchProperties>();
            for(PetalsMasterSearchCriteria sc : pdata.getCriteria()){
                l.add(ServiceSearchProperties.fromValue(sc.name()));
            }

            //call the service
            List<TechnicalServiceTO> services = s.searchService(pdata.getSearchPhrase(), l, options);

            //transform the response to match the method erasure
            Map<String,String> result = new HashMap<String,String>();
            for(TechnicalServiceTO service : services){
                String name = service.getName();
                QName qname = QName.valueOf(name);
                name = qname.getLocalPart();
                result.put(name, service.getId());
            }
            return result;
        } catch (Exception e) {
            throw new FileRepositoryInquiryException(e.getMessage());
        }
    }


}
