/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.jbi.bpel.sugenerator;

import com.ebmwebsourcing.easybox.api.XmlObjectReadException;
import com.ebmwebsourcing.jbi.sugenerator.SuGenerator;
import com.ebmwebsourcing.jbi.util.SOAAddress;
import com.ebmwebsourcing.petals.services.generation.cdk5.CdkConsumes5BeanDelegate;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.namespace.QName;
import org.junit.Assert;
import org.junit.Test;

public class SuGeneratorTest {
    @Test
    public void testBPEL() throws IOException, URISyntaxException, XmlObjectReadException {
        File inputFolder = new File("./src/test/resources");
        ArrayList<File> files = new ArrayList<File>();
        File[] listFiles = inputFolder.listFiles();
        for (int i = 0; i < listFiles.length; ++i) {
            if (listFiles[i].isDirectory() || !listFiles[i].getName().endsWith(".wsdl") && !listFiles[i].getName().endsWith(".WSDL") && !listFiles[i].getName().endsWith(".bpel") && !listFiles[i].getName().endsWith(".BPEL") && !listFiles[i].getName().endsWith(".xsd") && !listFiles[i].getName().endsWith(".XSD")) continue;
            files.add(listFiles[i]);
        }
        QName interfaceQName = new QName("http://org.ow2.petals/demo/travelagency/hotel/", "hotel");
        QName serviceQName = new QName("http://org.ow2.petals/demo/travelagency/hotel/", "hotel");
        SOAAddress ad = new SOAAddress("endpoint", serviceQName, interfaceQName);
        HashMap soaAddresses = new HashMap();
        ArrayList<SOAAddress> ads = new ArrayList<SOAAddress>();
        ads.add(ad);
        File hotel = new File(inputFolder, "hotel.wsdl");
        soaAddresses.put(hotel, ads);
        File bpelFile = new File(inputFolder, "process.bpel");
        File installFolder = new File("target");
        File suBPEL = SuGenerator.generateBPELProvide(soaAddresses, (File)bpelFile, files, (File)installFolder);
        Assert.assertNotNull((Object)suBPEL);
        Assert.assertEquals((Object)true, (Object)suBPEL.exists());
        File soapConsume = SuGenerator.generateSOAPConsume((String)"hotelSoap", (QName)interfaceQName, (QName)serviceQName, (QName)new QName("http://operationNamespace", "ope"), (CdkConsumes5BeanDelegate.MEP)CdkConsumes5BeanDelegate.MEP.InOut, (String)"NameExposed", (File)new File(System.getProperty("java.io.tmpdir") + "/TestSuGenerator.testSOAPConsume"));
        Assert.assertNotNull((Object)soapConsume);
        Assert.assertEquals((Object)true, (Object)soapConsume.exists());
        File soapProvide = SuGenerator.generateDefaultSoapProvide((String)"http://666.666.666.666/TutuService", (String)"Tutu666Endpoint", (QName)new QName("http://666/Tutu", "TutuInterface"), (QName)new QName("http://666/TutuService", "TutuService"), (String)listFiles[0].getName(), null, (File)new File(System.getProperty("java.io.tmpdir") + "/TestSuGenerator.testSOAPProvide"));
        Assert.assertNotNull((Object)soapProvide);
        Assert.assertEquals((Object)true, (Object)soapProvide.exists());
    }
}

