/**
 * sa-manager - A Web based designer for BPMN 2.0 standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.jbi.util;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.petals.services.generation.cdk5.CdkConsumes5BeanDelegate.MEP;

public class SOAAddress {

    private String endpoint;
    private QName service;
    private QName _interface;
    private String address;
    private QName operation;
    private MEP mep;

    public SOAAddress(String endpoint, QName service, QName _interface) {
        this.endpoint = endpoint;
        this.service = service;
        this._interface = _interface;
        this.address = null;
        this.operation = null;
        this.mep = null;
    }

    public SOAAddress(String endpoint, QName service, QName _interface, String address) {
        this(endpoint,service,_interface);
        this.address = address;
    }

    public String getEndpoint() {
        return endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public QName getService() {
        return service;
    }

    public void setService(QName service) {
        this.service = service;
    }

    public QName get_interface() {
        return _interface;
    }

    public void set_interface(QName interface1) {
        _interface = interface1;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public QName getOperation() {
        return operation;
    }

    public void setOperation(QName operation) {
        this.operation = operation;
    }

    public MEP getMep() {
        return mep;
    }

    public void setMep(MEP mep) {
        this.mep = mep;
    }

    @Override
    public String toString() {
        String res = null;

        StringBuilder sb = new StringBuilder();
        sb.append(this._interface);
        sb.append(this.service);
        sb.append(this.endpoint);
        sb.append(this.address);

        res = sb.toString();

        return res;
    }

}
